/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.mapper.xml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.noear.waad.DbContext;
import org.noear.waad.DbProcedure;
import org.noear.waad.WaadConfig;
import org.noear.waad.cache.ICacheService;
import org.noear.waad.core.DbCommandImpl;
import org.noear.waad.core.SQLBuilder;
import org.noear.waad.mapper.xml.XmlSqlBlock;
import org.noear.waad.mapper.xml.XmlSqlFactory;
import org.noear.waad.util.EntityUtils;
import org.noear.waad.util.StrUtils;
import org.noear.waad.util.ThrowableUtils;

public class DbXmlSqlProcedure
extends DbProcedure {
    private String _sqlid;
    private Map<String, Object> _map = new HashMap<String, Object>();

    public DbXmlSqlProcedure(DbContext context) {
        super(context);
    }

    public DbXmlSqlProcedure sql(String sqlid) {
        this._sqlid = sqlid;
        this.commandText = sqlid;
        this.args.clear();
        this._waadKey = null;
        return this;
    }

    public DbProcedure set(String param, Object value) {
        this._map.put(param, value);
        return this;
    }

    public DbProcedure setMap(Map<String, Object> map) {
        if (map != null) {
            map.forEach((k, v) -> this._map.put((String)k, v));
        }
        return this;
    }

    public DbProcedure setEntity(Object obj) {
        EntityUtils.fromEntity((Object)obj, (k, v) -> this._map.put((String)k, v));
        return this;
    }

    protected String getCommandID() {
        return this.commandText;
    }

    public String getWaadKey() {
        if (this._waadKey == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCommandID()).append(":");
            for (Object p : this._map.values()) {
                sb.append("_").append(p);
            }
            this._waadKey = sb.toString();
        }
        return this._waadKey;
    }

    protected DbCommandImpl getCommand() {
        DbCommandImpl cmd = new DbCommandImpl(this.context);
        cmd.key = this.getCommandID();
        XmlSqlBlock block = XmlSqlFactory.get(this._sqlid);
        if (block == null || block.builder == null) {
            throw new RuntimeException("Sql @" + this._sqlid + " does not exist");
        }
        SQLBuilder sqlBuilder = null;
        try {
            sqlBuilder = block.builder.build(this._map);
        }
        catch (Throwable ex) {
            System.out.println("[Waad] " + block.getClasscode(true));
            ex = ThrowableUtils.throwableUnwrap((Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        for (Object p1 : sqlBuilder.paramS) {
            this.doSet("", p1);
        }
        cmd.text = sqlBuilder.toString();
        cmd.args = this.args;
        cmd.attachment = this._map;
        this.tryCacheController(cmd, block);
        this.runCommandBuiltEvent(cmd);
        return cmd;
    }

    private void tryCacheController(DbCommandImpl cmd, XmlSqlBlock block) {
        if (!StrUtils.isEmpty((String)block._caching) && this._cache == null) {
            cmd.cache = (ICacheService)WaadConfig.libOfCache.get(block._caching);
            if (cmd.cache == null) {
                throw new RuntimeException("WaadConfig.libOfCache does not exist:@" + block._caching);
            }
            if (block.isSelect()) {
                this.caching(cmd.cache);
                if (!StrUtils.isEmpty((String)block._usingCache)) {
                    this.usingCache(Integer.parseInt(block._usingCache));
                }
                if (!StrUtils.isEmpty((String)block._cacheTag)) {
                    this._cache.usingCache((uc, obj) -> Arrays.asList(block.formatAppendTags(block, this._map, obj).split(",")).forEach(k -> this.cacheTag(k.trim())));
                }
            } else if (!StrUtils.isEmpty((String)block._cacheClear)) {
                cmd.onExecuteAft = c -> Arrays.asList(block.formatRemoveTags(block, this._map).split(",")).forEach(k -> c.cache.clear(k.trim()));
            }
        }
    }
}

