/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.mapper.xml;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.noear.waad.util.IOUtils;

class XmlFileScaner {
    XmlFileScaner() {
    }

    public static Set<String> scan(String path, String suffix) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        try {
            Enumeration roots = IOUtils.getResources((String)path);
            while (roots.hasMoreElements()) {
                URL url = (URL)roots.nextElement();
                String p = url.getProtocol();
                if ("file".equals(p)) {
                    String fp = URLDecoder.decode(url.getFile(), "UTF-8");
                    XmlFileScaner.doScanByFile(new File(fp), path, suffix, urls);
                    continue;
                }
                if (!"jar".equals(p)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                XmlFileScaner.doScanByJar(path, jar, suffix, urls);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return urls;
    }

    private static void doScanByFile(File dir, String path, String suffix, Set<String> urls) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(f -> f.isDirectory() || f.getName().endsWith(suffix));
        if (dirfiles != null) {
            for (File f2 : dirfiles) {
                String p2 = path + "/" + f2.getName();
                if (f2.isDirectory()) {
                    XmlFileScaner.doScanByFile(f2, p2, suffix, urls);
                    continue;
                }
                urls.add(p2);
            }
        }
    }

    private static void doScanByJar(String path, JarFile jar, String suffix, Set<String> urls) {
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            JarEntry e = entry.nextElement();
            String n = e.getName();
            if (n.charAt(0) == '/') {
                n = n.substring(1);
            }
            if (e.isDirectory() || !n.startsWith(path) || !n.endsWith(suffix)) continue;
            urls.add(n);
        }
    }
}

