/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.generator.entity;

import java.util.ArrayList;
import java.util.List;
import org.noear.waad.DbContext;
import org.noear.waad.generator.entity.block.TableItem;
import org.noear.waad.generator.entity.block.XmlEntityBlock;
import org.noear.waad.generator.entity.block.XmlSourceBlock;
import org.noear.waad.generator.entity.block.XmlTableBlock;
import org.noear.waad.generator.utils.NamingUtils;
import org.noear.waad.generator.utils.StringUtils;
import org.noear.waad.generator.utils.XmlUtils;
import org.noear.waad.wrap.TableWrap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser {
    public static XmlSourceBlock getSource(Node n1) throws Exception {
        if (!"source".equals(n1.getNodeName())) {
            return null;
        }
        XmlSourceBlock source = new XmlSourceBlock();
        source.schema = XmlUtils.attr(n1, "schema");
        source.url = XmlUtils.attr(n1, "url");
        source.username = XmlUtils.attr(n1, "username");
        source.password = XmlUtils.attr(n1, "password");
        source.driverClassName = XmlUtils.attr(n1, "driverClassName");
        source.namingStyle = XmlUtils.attr(n1, "namingStyle");
        source.typeStyle = XmlUtils.attr(n1, "typeStyle");
        if (source.typeStyle == null) {
            source.typeStyle = "";
        }
        NodeList n2l = n1.getChildNodes();
        int len = n2l.getLength();
        for (int i = 0; i < len; ++i) {
            Object bk;
            Node n2 = n2l.item(i);
            if (n2.getNodeType() != 1) continue;
            if ("entityGenerator".equals(n2.getNodeName())) {
                bk = new XmlEntityBlock();
                ((XmlEntityBlock)bk).targetPackage = XmlUtils.attr(n2, "targetPackage");
                ((XmlEntityBlock)bk).entityName = XmlUtils.attr(n2, "entityName");
                ((XmlEntityBlock)bk).code = XmlParser.getCode(n2);
                source.entityBlocks.add((XmlEntityBlock)bk);
            }
            if (!"table".equals(n2.getNodeName())) continue;
            bk = new XmlTableBlock();
            ((XmlTableBlock)bk).tableName = XmlUtils.attr(n2, "tableName");
            ((XmlTableBlock)bk).domainName = XmlUtils.attr(n2, "domainName");
            source.tableBlocks.add((XmlTableBlock)bk);
        }
        return source;
    }

    public static String getCode(Node n2) {
        StringBuilder sb = new StringBuilder();
        NodeList nl = n2.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n3 = nl.item(i);
            sb.append(n3.getTextContent());
        }
        return sb.toString();
    }

    public static List<TableItem> getTables(XmlSourceBlock source, DbContext db) {
        ArrayList<TableItem> tableItems = new ArrayList<TableItem>();
        for (XmlTableBlock tb : source.tableBlocks) {
            TableItem item;
            if ("*".equals(tb.tableName)) {
                for (TableWrap tw : db.metaData().getTableAll()) {
                    item = new TableItem();
                    item.tableName = tw.getName();
                    item.domainName = NamingUtils.toCamelString(item.tableName, true);
                    item.tableWrap = tw;
                    tableItems.add(item);
                }
                break;
            }
            for (TableWrap tw : db.metaData().getTableAll()) {
                if (!tw.getName().equals(tb.tableName)) continue;
                item = new TableItem();
                item.tableName = tw.getName();
                item.domainName = StringUtils.isEmpty(tb.domainName) ? NamingUtils.toCamelString(item.tableName, true) : tb.domainName;
                item.tableWrap = tw;
                tableItems.add(item);
            }
        }
        return tableItems;
    }
}

