/*
 * Decompiled with CFR 0.152.
 */
package org.noear.waad.generator.utils;

import java.util.regex.Pattern;

public class NamingUtils {
    private static Pattern LOWER_CASE = Pattern.compile("[a-z]");

    public static String toLowerCaseIfAllUpperCase(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (LOWER_CASE.matcher(name).find()) {
            return name;
        }
        return name.toLowerCase();
    }

    public static String toCamelString(String name) {
        return NamingUtils.toCamelString(name, false);
    }

    public static String toCamelString(String name, boolean startsWithUpperCase) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = NamingUtils.toLowerCaseIfAllUpperCase(name.trim()).toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean underline = startsWithUpperCase;
        for (char c : chars) {
            if (c == '_') {
                underline = true;
                continue;
            }
            if (underline) {
                buffer.append(Character.toUpperCase(c));
            } else {
                buffer.append(c);
            }
            underline = false;
        }
        return buffer.toString();
    }

    public static String toUnderlineString(String name) {
        return NamingUtils.toSeparatorString(name, '_');
    }

    public static String toSpaceSplitString(String name) {
        return NamingUtils.toSeparatorString(name, ' ');
    }

    private static String toSeparatorString(String name, char separator) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.trim().toCharArray();
        boolean lastLowerCase = false;
        StringBuilder buffer = new StringBuilder();
        for (char c : chars) {
            if (Character.isWhitespace(c)) {
                if (lastLowerCase) {
                    buffer.append(separator);
                }
                lastLowerCase = false;
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (lastLowerCase) {
                    buffer.append(separator);
                }
                buffer.append(Character.toLowerCase(c));
                lastLowerCase = false;
                continue;
            }
            buffer.append(c);
            lastLowerCase = Character.isLowerCase(c) || Character.isDigit(c);
        }
        return buffer.toString();
    }

    public static String capitalize(String str) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return new StringBuilder(len).append(Character.toTitleCase(firstChar)).append(str.substring(1)).toString();
    }
}

