package org.noear.waad.cache;

import org.noear.waad.utils.fun.Fun1;

import java.lang.reflect.Type;

/**
 * 二级缓存容器
 *
 * @author noear
 * @since 3.0
 * */
public class SecondCache implements ICacheService {
    private ICacheService cache1;
    private ICacheService cache2;
    private int bufferSeconds;

    public SecondCache(ICacheService cache1, ICacheService cache2) {
        this(cache1, cache2, 5);
    }

    public SecondCache(ICacheService cache1, ICacheService cache2, int bufferSeconds) {
        this.cache1 = cache1;
        this.cache2 = cache2;
        this.bufferSeconds = bufferSeconds;
    }

    @Override
    public void store(String key, Object obj, int seconds) {
        cache1.store(key, obj, seconds);
        cache2.store(key, obj, seconds);
    }

    @Override
    public <T> T get(String key, Type type) {
        T temp = cache1.get(key, type);

        if (temp == null) {
            temp = cache2.get(key, type);
            if (bufferSeconds > 0 && temp != null) {
                cache1.store(key, temp, bufferSeconds);
            }
        }

        return temp;
    }

    @Override
    public void remove(String key) {
        cache1.remove(key);
        cache2.remove(key);
    }

    @Override
    public int getDefalutSeconds() {
        return cache1.getDefalutSeconds();
    }

    @Override
    public String getCacheKeyHead() {
        return cache1.getCacheKeyHead();
    }

    //////////

    @Override
    public CacheTags tags() {
        return cache1.tags();
    }

    @Override
    public void clear(String tag) {
        cache1.clear(tag);
        cache2.clear(tag);
    }

    @Override
    public <T> void update(String tag, Class<T> clz, Fun1<T, T> setter) {
        cache1.update(tag, clz, setter);
        cache2.update(tag, clz, setter);
    }
}