/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.water.service.ConvertUtil;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.solon.core.Signal;
import org.noear.solon.core.event.EventBus;
import org.noear.water.WaterClient;
import org.noear.water.model.DiscoverM;

public class CloudDiscoveryServiceWaterImp
extends TimerTask
implements CloudDiscoveryService {
    String alarmMobile;
    long refreshInterval;
    boolean unstable;
    Map<String, String> serviceMap = new HashMap<String, String>();
    Map<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> observerMap = new HashMap<CloudDiscoveryHandler, CloudDiscoveryObserverEntity>();

    public CloudDiscoveryServiceWaterImp(CloudProps cloudProps) {
        this.unstable = cloudProps.getDiscoveryUnstable() || Solon.cfg().isFilesMode() || Solon.cfg().isDriftMode();
        this.alarmMobile = cloudProps.getAlarm();
        this.refreshInterval = IntervalUtils.getInterval((String)cloudProps.getDiscoveryRefreshInterval("5s"));
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void run() {
        try {
            if (Solon.cfg().isFilesMode()) {
                this.runByFile();
            }
        }
        catch (Throwable e) {
            EventBus.push((Object)e);
        }
    }

    private void runByFile() {
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            try {
                for (Signal signal : Solon.app().signals()) {
                    Instance instance = Instance.localNew((Signal)signal);
                    this.register(Solon.cfg().appGroup(), instance);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.observerMap.forEach((k, v) -> this.onUpdate(v.group, v.service));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void register(String group, Instance instance) {
        String meta = null;
        if (instance.meta() != null && instance.meta().size() > 0) {
            meta = ONode.stringify((Object)instance.meta());
        }
        String protocol = Utils.annoAlias((String)instance.protocol(), (String)"http");
        String code_location = Solon.cfg().sourceLocation().getPath();
        String checkPath = protocol.startsWith("http") ? "/healthz" : instance.uri();
        if (Solon.cfg().isFilesMode()) {
            WaterClient.Registry.register(Solon.cfg().appGroup(), instance.service(), instance.address(), meta, checkPath, 1, this.alarmMobile, code_location, this.unstable);
        } else {
            WaterClient.Registry.register(Solon.cfg().appGroup(), instance.service(), instance.address(), meta, checkPath, 0, this.alarmMobile, code_location, this.unstable);
        }
    }

    public void registerState(String group, Instance instance, boolean health) {
        String meta = null;
        if (instance.meta() != null) {
            meta = ONode.stringify((Object)instance.meta());
        }
        WaterClient.Registry.set(group, instance.service(), instance.address(), meta, health);
    }

    public void deregister(String group, Instance instance) {
        String meta = null;
        if (instance.meta() != null) {
            meta = ONode.stringify((Object)instance.meta());
        }
        WaterClient.Registry.unregister(group, instance.service(), instance.address(), meta);
    }

    public Discovery find(String group, String service) {
        Instance instance = Instance.local();
        DiscoverM d1 = WaterClient.Registry.discover(group, service, instance.service(), instance.address());
        return ConvertUtil.from(service, d1);
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        this.observerMap.put(observer, new CloudDiscoveryObserverEntity(group, service, observer));
        this.serviceMap.put(service, service);
    }

    public void onUpdate(String group, String service) {
        if (this.serviceMap.containsKey(service)) {
            Discovery discovery = this.find(group, service);
            this.observerMap.forEach((k, v) -> {
                if (service.equals(v.service)) {
                    v.handle(discovery);
                }
            });
        }
    }
}

