/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.water.service.SnowflakeUtil;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.logging.event.LogEvent;
import org.noear.water.dso.LogPipeline;
import org.noear.water.model.LogM;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.LogHelper;

public class CloudLogServiceWaterImp
implements CloudLogService {
    private String loggerNameDefault;

    public CloudLogServiceWaterImp(CloudProps cloudProps) {
        this.loggerNameDefault = cloudProps.getLogDefault();
        if (Utils.isEmpty((String)this.loggerNameDefault) && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            this.loggerNameDefault = Solon.cfg().appName() + "_log";
        }
        if (Utils.isEmpty((String)this.loggerNameDefault)) {
            System.err.println("[WARN] Solon.cloud no default logger is configured");
        }
    }

    public void append(LogEvent logEvent) {
        String loggerName = logEvent.getLoggerName();
        if (Utils.isEmpty((String)loggerName)) {
            return;
        }
        if (loggerName.contains(".")) {
            loggerName = this.loggerNameDefault;
        }
        Datetime datetime = Datetime.Now();
        LogM log = new LogM();
        log.log_id = SnowflakeUtil.genId();
        log.group = Solon.cfg().appGroup();
        log.service = Solon.cfg().appName();
        log.logger = loggerName;
        log.level = logEvent.getLevel().code / 10;
        log.content = LogHelper.contentAsString((Object)logEvent.getContent());
        if (logEvent.getMetainfo() != null) {
            log.tag = (String)logEvent.getMetainfo().get("tag0");
            log.tag1 = (String)logEvent.getMetainfo().get("tag1");
            log.tag2 = (String)logEvent.getMetainfo().get("tag2");
            log.tag3 = (String)logEvent.getMetainfo().get("tag3");
            log.tag4 = (String)logEvent.getMetainfo().get("tag4");
        }
        if (logEvent.getLoggerName().contains(".")) {
            log.class_name = logEvent.getLoggerName();
        }
        log.thread_name = Thread.currentThread().getName();
        log.trace_id = CloudClient.trace().getTraceId();
        log.from = Instance.local().serviceAndAddress();
        log.log_date = datetime.getDate();
        log.log_fulltime = datetime.getFulltime();
        LogPipeline.singleton().add((Object)log);
    }
}

