/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.solon.core.event.EventBus;
import org.noear.water.WaterClient;
import org.noear.water.model.ConfigM;

public class CloudConfigServiceWaterImp
extends TimerTask
implements CloudConfigService {
    private final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private long refreshInterval;
    private Map<String, Config> configMap = new HashMap<String, Config>();
    private Map<CloudConfigHandler, CloudConfigObserverEntity> observerMap = new HashMap<CloudConfigHandler, CloudConfigObserverEntity>();

    public CloudConfigServiceWaterImp(CloudProps cloudProps) {
        this.refreshInterval = IntervalUtils.getInterval((String)cloudProps.getConfigRefreshInterval("5s"));
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
    }

    private void run0() {
        if (Solon.cfg().isFilesMode()) {
            LinkedHashSet loadGroups = new LinkedHashSet();
            try {
                this.observerMap.forEach((k, v) -> {
                    if (!loadGroups.contains(v.group)) {
                        loadGroups.add(v.group);
                        WaterClient.Config.reload(v.group);
                    }
                    ConfigM cfg = WaterClient.Config.get(v.group, v.key);
                    this.onUpdateDo(v.group, v.key, cfg, cfg2 -> v.handle(cfg2));
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Config pull(String group, String key) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        ConfigM cfg = WaterClient.Config.get(group, key);
        String cfgKey = group + "/" + key;
        Config config = this.configMap.get(cfgKey);
        if (config == null) {
            config = new Config(group, key, cfg.value, cfg.lastModified);
            this.configMap.put(cfgKey, config);
        } else if (cfg.lastModified > config.version()) {
            config.updateValue(cfg.value, cfg.lastModified);
        }
        return config;
    }

    public boolean push(String group, String key, String value) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        try {
            WaterClient.Config.set(group, key, value);
            return true;
        }
        catch (IOException e) {
            EventBus.pushTry((Object)e);
            return false;
        }
    }

    public boolean remove(String group, String key) {
        return false;
    }

    public void attention(String group, String key, CloudConfigHandler observer) {
        if (this.observerMap.containsKey(observer)) {
            return;
        }
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, key, observer);
        this.observerMap.put(observer, entity);
    }

    public void onUpdate(String group, String key) {
        if (Utils.isEmpty((String)group)) {
            return;
        }
        WaterClient.Config.reload(group);
        ConfigM cfg = WaterClient.Config.get(group, key);
        this.onUpdateDo(group, key, cfg, cfg2 -> this.observerMap.forEach((k, v) -> {
            if (group.equals(v.group) && key.equals(v.key)) {
                v.handle(cfg2);
            }
        }));
    }

    private void onUpdateDo(String group, String key, ConfigM cfg, Consumer<Config> consumer) {
        String cfgKey = group + "/" + key;
        Config config = this.configMap.get(cfgKey);
        if (config == null) {
            config = new Config(group, key, cfg.value, cfg.lastModified);
        } else if (config.version() < cfg.lastModified) {
            config.updateValue(cfg.value, cfg.lastModified);
        } else {
            return;
        }
        consumer.accept(config);
    }
}

