/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.integration.http;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.extend.water.service.CloudJobServiceWaterImp;
import org.noear.solon.cloud.model.JobHolder;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public class HandlerJob
implements Handler {
    public void handle(Context ctx) throws Throwable {
        String token = ctx.header("Water-Access-Token", "");
        if (this.authServerToken(token)) {
            String name = ctx.header("Water-Job-Name");
            if (Utils.isEmpty((String)name)) {
                name = ctx.param("name");
            }
            this.handleDo(ctx, name);
        } else {
            ctx.status(400);
            ctx.output("Invalid server token!");
        }
    }

    private void handleDo(Context ctx, String name) {
        JobHolder jobHolder = CloudJobServiceWaterImp.instance.get(name);
        if (jobHolder == null) {
            ctx.status(400);
            if (Utils.isEmpty((String)name)) {
                ctx.output("CloudJob need the name parameter");
            } else {
                ctx.output("CloudJob[" + name + "] no exists");
            }
        } else {
            try {
                jobHolder.handle(ctx);
                ctx.output("OK");
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap((Throwable)e);
                EventBus.pushTry((Object)e);
                ctx.status(500);
                ctx.output(e);
            }
        }
    }

    private boolean authServerToken(String token) {
        return CloudClient.list().inListOfServerToken(token);
    }
}

