/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Pack;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.core.Props;
import org.noear.water.WaterClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudI18nServiceWaterImpl
implements CloudI18nService {
    static final Logger log = LoggerFactory.getLogger(CloudI18nServiceWaterImpl.class);
    private String packNameDefault;
    private Map<String, Pack> packMap = new HashMap<String, Pack>();

    public CloudI18nServiceWaterImpl(CloudProps cloudProps) {
        this.packNameDefault = cloudProps.getI18nDefault();
        if (Utils.isEmpty((String)this.packNameDefault)) {
            this.packNameDefault = Solon.cfg().appName();
        }
        if (Utils.isEmpty((String)this.packNameDefault)) {
            System.err.println("[WARN] Solon.cloud no default i18n is configured");
        }
    }

    public Pack pull(String group, String packName, Locale locale) {
        if (Utils.isEmpty((String)packName)) {
            packName = this.packNameDefault;
        }
        try {
            return this.pullDo(group, packName, locale);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pack pullDo(String group, String packName, Locale locale) throws IOException {
        String packKey = String.format("%s:%s:%s", group, packName, locale.toString().toLowerCase(Locale.ROOT));
        Pack pack = this.packMap.get(packKey);
        if (pack == null) {
            Map<String, Pack> map = this.packMap;
            synchronized (map) {
                pack = this.packMap.get(packKey);
                if (pack == null) {
                    pack = new Pack(locale);
                    Map data = WaterClient.I18n.getI18n(group, packName, pack.getLang());
                    pack.setData(new Props(data));
                }
                this.packMap.put(packKey, pack);
            }
        }
        return pack;
    }

    public void onUpdate(String group, String packName, String lang) {
        String packKey = String.format("%s:%s:%s", group, packName, lang.toLowerCase(Locale.ROOT));
        Pack pack = this.packMap.get(packKey);
        if (pack != null) {
            try {
                Map data = WaterClient.I18n.getI18nNoCache(group, packName, pack.getLang());
                pack.setData(new Props(data));
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
    }
}

