/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.CloudJobHandler;
import org.noear.solon.cloud.model.JobHolder;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.water.WaterClient;
import org.noear.water.model.JobM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudJobServiceWaterImpl
implements CloudJobService {
    static final Logger log = LoggerFactory.getLogger(CloudJobServiceWaterImpl.class);
    public static final CloudJobServiceWaterImpl instance = new CloudJobServiceWaterImpl();
    public Map<String, JobHolder> jobMap = new LinkedHashMap<String, JobHolder>();

    public JobHolder get(String name) {
        return this.jobMap.get(name);
    }

    public void push() {
        if (this.jobMap.size() == 0) {
            return;
        }
        ArrayList jobs = new ArrayList();
        this.jobMap.forEach((k, v) -> jobs.add(new JobM(v.getName(), v.getCron7x(), v.getDescription())));
        try {
            WaterClient.Job.register(Solon.cfg().appGroup(), Solon.cfg().appName(), jobs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean register(String name, String cron7x, String description, CloudJobHandler handler) {
        JobHolder jobHolder = new JobHolder(name, cron7x, description, handler);
        this.jobMap.put(name, jobHolder);
        TagsMDC.tag0((String)"CloudJob");
        log.info("CloudJob: Handler registered name:" + name + ", class:" + handler.getClass().getName());
        TagsMDC.tag0((String)"");
        return true;
    }

    public boolean isRegistered(String name) {
        return this.jobMap.containsKey(name);
    }
}

