/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.integration.msg;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.water.service.CloudDiscoveryServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudI18nServiceWaterImpl;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.wood.WoodConfig;
import org.noear.wood.cache.ICacheServiceEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerCacheUpdate
implements CloudEventHandler {
    static Logger logger = LoggerFactory.getLogger((String)"water_log_upstream");
    CloudDiscoveryServiceWaterImpl discoveryService;
    CloudI18nServiceWaterImpl i18nService;

    public HandlerCacheUpdate(CloudDiscoveryServiceWaterImpl discoveryService, CloudI18nServiceWaterImpl i18nService) {
        this.discoveryService = discoveryService;
        this.i18nService = i18nService;
    }

    public boolean handle(Event event) {
        String[] tagKeyAry;
        for (String tagKey : tagKeyAry = event.content().split(";")) {
            if (!Utils.isNotEmpty((String)tagKey)) continue;
            this.cacheUpdateHandler0(tagKey);
            this.cacheUpdateHandler1(tagKey);
        }
        return true;
    }

    public boolean cacheUpdateHandler0(String tagKey) {
        String[] ss = null;
        ss = tagKey.contains("::") ? tagKey.split("::") : tagKey.split(":");
        if (this.discoveryService != null && "upstream".equals(ss[0])) {
            String service = ss[1];
            try {
                this.discoveryService.onUpdate("", service);
            }
            catch (Exception ex) {
                TagsMDC.tag0((String)ss[1]);
                TagsMDC.tag1((String)"reload");
                logger.error("{}", (Throwable)ex);
            }
            return true;
        }
        if (this.i18nService != null && "i18n".equals(ss[0]) && ss.length >= 4) {
            this.i18nService.onUpdate(ss[1], ss[2], ss[3]);
            return true;
        }
        return false;
    }

    public void cacheUpdateHandler1(String tag) {
        if (tag.indexOf(".") > 0) {
            ICacheServiceEx cache;
            String[] ss = tag.split("\\.");
            if (ss.length == 2 && (cache = (ICacheServiceEx)WoodConfig.libOfCache.get(ss[0])) != null) {
                cache.clear(ss[1]);
            }
        } else {
            for (ICacheServiceEx cache : WoodConfig.libOfCache.values()) {
                cache.clear(tag);
            }
        }
    }
}

