/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.integration.http;

import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.water.service.CloudEventServiceWaterImpl;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.water.WaterClient;
import org.noear.water.dso.MessageHandler;
import org.noear.water.model.MessageM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerReceive
implements Handler,
MessageHandler {
    static final Logger log = LoggerFactory.getLogger(HandlerReceive.class);
    private CloudEventServiceWaterImpl eventService;

    public HandlerReceive(CloudEventServiceWaterImpl eventService) {
        this.eventService = eventService;
    }

    public void handle(Context ctx) throws Throwable {
        try {
            if (MethodType.HEAD.name.equals(ctx.method()) || ctx.paramMap().size() == 0) {
                ctx.output("HEAD-OK");
                return;
            }
            String rst = WaterClient.Message.receiveMessage(arg_0 -> ((Context)ctx).param(arg_0), this.eventService.getSeal(), (MessageHandler)this);
            ctx.output(rst);
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            log.warn(e.getMessage(), e);
            ctx.output(e);
        }
    }

    public boolean handle(MessageM msg) throws Throwable {
        Event event = null;
        if (msg.topic.contains(":")) {
            String[] groupAndTopic = msg.topic.split(":");
            event = new Event(groupAndTopic[1], msg.message);
            event.group(groupAndTopic[0]);
        } else {
            event = new Event(msg.topic, msg.message);
        }
        event.key(msg.key);
        event.tags(msg.tags);
        event.times(msg.times);
        return this.eventService.onReceive(msg.topic, event);
    }
}

