/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.cloud.CloudDiscoveryHandler;
import org.noear.solon.cloud.extend.water.WaterProps;
import org.noear.solon.cloud.extend.water.service.ConvertUtil;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudDiscoveryObserverEntity;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.solon.core.event.EventBus;
import org.noear.water.WaterClient;
import org.noear.water.model.DiscoverM;

public class CloudDiscoveryServiceImp
extends TimerTask
implements CloudDiscoveryService {
    String checkPath;
    String alarmMobile;
    long refreshInterval;
    Map<CloudDiscoveryHandler, CloudDiscoveryObserverEntity> observerMap = new HashMap<CloudDiscoveryHandler, CloudDiscoveryObserverEntity>();

    public CloudDiscoveryServiceImp() {
        this.checkPath = WaterProps.instance.getDiscoveryHealthCheckPath();
        this.alarmMobile = WaterProps.instance.getAlarm();
        this.refreshInterval = IntervalUtils.getInterval((String)WaterProps.instance.getDiscoveryRefreshInterval("5s"));
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    private void run0() {
        if (Solon.cfg().isFilesMode()) {
            try {
                Instance instance = Instance.local();
                String meta = null;
                if (instance.meta() != null && instance.meta().size() > 0) {
                    meta = ONode.stringify((Object)instance.meta());
                }
                String code_location = Solon.cfg().sourceLocation().getPath();
                WaterClient.Registry.register(instance.service(), instance.address(), meta, this.checkPath, 1, this.alarmMobile, code_location, this.is_unstable());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void register(String group, Instance instance) {
        String meta = null;
        if (instance.meta() != null && instance.meta().size() > 0) {
            meta = ONode.stringify((Object)instance.meta());
        }
        String code_location = Solon.cfg().sourceLocation().getPath();
        if (Solon.cfg().isFilesMode()) {
            WaterClient.Registry.register(instance.service(), instance.address(), meta, this.checkPath, 1, this.alarmMobile, code_location, this.is_unstable());
        } else {
            WaterClient.Registry.register(instance.service(), instance.address(), meta, this.checkPath, 0, this.alarmMobile, code_location, this.is_unstable());
        }
    }

    private boolean is_unstable() {
        return Solon.cfg().isFilesMode() || Solon.cfg().isDriftMode();
    }

    public void registerState(String group, Instance instance, boolean health) {
        String meta = null;
        if (instance.meta() != null) {
            meta = ONode.stringify((Object)instance.meta());
        }
        WaterClient.Registry.set(instance.service(), instance.address(), meta, health);
    }

    public void deregister(String group, Instance instance) {
        String meta = null;
        if (instance.meta() != null) {
            meta = ONode.stringify((Object)instance.meta());
        }
        WaterClient.Registry.unregister(instance.service(), instance.address(), meta);
    }

    public Discovery find(String group, String service) {
        Instance instance = Instance.local();
        DiscoverM d1 = WaterClient.Registry.discover(service, instance.service(), instance.address());
        return ConvertUtil.from(service, d1);
    }

    public void attention(String group, String service, CloudDiscoveryHandler observer) {
        this.observerMap.put(observer, new CloudDiscoveryObserverEntity(group, service, observer));
    }

    public void onUpdate(String group, String service) {
        Discovery discovery = this.find(group, service);
        this.observerMap.forEach((k, v) -> {
            if (service.equals(v.service)) {
                v.handler(discovery);
            }
        });
    }
}

