/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.util.Date;
import org.noear.mlog.Level;
import org.noear.mlog.LoggerSimple;
import org.noear.mlog.Metainfo;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudLogger;
import org.noear.solon.cloud.extend.water.WaterProps;
import org.noear.solon.core.util.PrintUtil;
import org.noear.water.WaterClient;
import org.noear.water.dso.LogPipeline;
import org.noear.water.log.LogEvent;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.TextUtils;

public class CloudLoggerImp
extends LoggerSimple
implements CloudLogger {
    public CloudLoggerImp(String name) {
        super(name);
    }

    public CloudLoggerImp(Class<?> clz) {
        super(clz);
        this.name = WaterProps.instance.getLogDefault();
        if (Utils.isEmpty((String)this.name)) {
            System.err.println("[WARN] Solon.cloud no default logger is configured");
        }
    }

    public void write(Level level, Metainfo metainfo, Object content) {
        StringBuilder summary = new StringBuilder();
        summary.append("[").append(Thread.currentThread().getName()).append("]");
        if (this.clz != null) {
            if (metainfo == null) {
                metainfo = new Metainfo();
            }
            metainfo.put("tag3", this.clz.getSimpleName());
            summary.append("[").append(this.clz.getTypeName()).append("]");
        }
        if (TextUtils.isEmpty((CharSequence)this.getName())) {
            this.print0(level, metainfo, content);
        } else if (metainfo == null) {
            this.write0(level, null, null, null, null, summary.toString(), content);
        } else {
            this.write0(level, metainfo.get("tag0"), metainfo.get("tag1"), metainfo.get("tag2"), metainfo.get("tag3"), summary.toString(), content);
        }
    }

    private void write0(Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (TextUtils.isEmpty((CharSequence)this.getName())) {
            return;
        }
        Datetime datetime = Datetime.Now();
        LogEvent log = new LogEvent();
        log.logger = this.getName();
        log.level = level.code / 10;
        log.tag = tag;
        log.tag1 = tag1;
        log.tag2 = tag2;
        log.tag3 = tag3;
        log.summary = summary;
        log.content = content;
        if (this.clz != null) {
            if (TextUtils.isEmpty((CharSequence)summary)) {
                log.summary = this.clz.getTypeName();
            }
            if (TextUtils.isEmpty((CharSequence)tag3)) {
                log.tag3 = this.clz.getSimpleName();
            }
        }
        log.trace_id = WaterClient.waterTraceId();
        log.from = WaterClient.localServiceHost();
        log.thread = Thread.currentThread().getName();
        log.log_date = datetime.getDate();
        log.log_fulltime = datetime.getFulltime();
        LogPipeline.singleton().add((Object)log);
    }

    private void print0(Level level, Metainfo metainfo, Object content) {
        String levelStr = "[" + level.name() + "]";
        switch (level) {
            case ERROR: {
                PrintUtil.red((String)levelStr);
                break;
            }
            case INFO: {
                PrintUtil.green((String)levelStr);
                break;
            }
            default: {
                PrintUtil.black((String)levelStr);
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" ").append(new Date().toInstant()).append(" ");
        buf.append("[").append(Thread.currentThread().getName()).append("]");
        if (metainfo != null) {
            buf.append(metainfo.toString());
        }
        if (this.clz != null) {
            buf.append(" ").append(this.clz.getTypeName());
        }
        buf.append(" ::");
        if (content instanceof String) {
            buf.append(content);
        } else {
            buf.append(ONode.loadObj((Object)content));
        }
        if (level == Level.ERROR) {
            System.err.println(buf.toString());
        } else {
            System.out.println(buf.toString());
        }
    }
}

