/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.water.WaterProps;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.water.WaterClient;
import org.noear.water.dso.LogPipeline;
import org.noear.water.log.LogEvent;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.LogHelper;
import org.noear.water.utils.TextUtils;

public class CloudLogServiceWaterImp
implements CloudLogService {
    private String loggerNameDefault = WaterProps.instance.getLogDefault();

    public CloudLogServiceWaterImp() {
        if (Utils.isEmpty((String)this.loggerNameDefault) && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            this.loggerNameDefault = Solon.cfg().appName() + "_log";
        }
        if (Utils.isEmpty((String)this.loggerNameDefault)) {
            System.err.println("[WARN] Solon.cloud no default logger is configured");
        }
    }

    public void append(org.noear.solon.logging.event.LogEvent logEvent) {
        String loggerName = logEvent.getLoggerName();
        if (logEvent.getInitClass() != null) {
            loggerName = this.loggerNameDefault;
        }
        if (Utils.isEmpty((String)loggerName)) {
            return;
        }
        if (loggerName.contains(".")) {
            loggerName = this.loggerNameDefault;
        }
        Datetime datetime = Datetime.Now();
        LogEvent log = new LogEvent();
        log.group = Solon.cfg().appGroup();
        log.logger = loggerName;
        log.level = logEvent.getLevel().code / 10;
        log.content = LogHelper.contentAsString((Object)logEvent.getContent());
        if (logEvent.getMetainfo() != null) {
            log.tag = (String)logEvent.getMetainfo().get("tag0");
            log.tag1 = (String)logEvent.getMetainfo().get("tag1");
            log.tag2 = (String)logEvent.getMetainfo().get("tag2");
            log.tag3 = (String)logEvent.getMetainfo().get("tag3");
        }
        if (logEvent.getInitClass() != null) {
            if (TextUtils.isEmpty((CharSequence)log.tag3)) {
                log.tag3 = logEvent.getInitClass().getSimpleName();
            }
            log.class_name = logEvent.getInitClass().getCanonicalName();
        }
        log.trace_id = WaterClient.waterTraceId();
        log.from = WaterClient.localServiceHost();
        log.thread_name = Thread.currentThread().getName();
        log.log_date = datetime.getDate();
        log.log_fulltime = datetime.getFulltime();
        LogPipeline.singleton().add((Object)log);
    }
}

