/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.water.WaterProps;
import org.noear.solon.cloud.extend.water.integration.http.HandlerCheck;
import org.noear.solon.cloud.extend.water.integration.http.HandlerReceive;
import org.noear.solon.cloud.extend.water.integration.http.HandlerStatus;
import org.noear.solon.cloud.extend.water.integration.http.HandlerStop;
import org.noear.solon.cloud.extend.water.integration.msg.HandlerCacheUpdate;
import org.noear.solon.cloud.extend.water.integration.msg.HandlerConfigUpdate;
import org.noear.solon.cloud.extend.water.service.CloudConfigServiceImp;
import org.noear.solon.cloud.extend.water.service.CloudDiscoveryServiceImp;
import org.noear.solon.cloud.extend.water.service.CloudEventServiceImp;
import org.noear.solon.cloud.extend.water.service.CloudLockServiceImp;
import org.noear.solon.cloud.extend.water.service.CloudLogServiceImp;
import org.noear.solon.cloud.extend.water.service.CloudTraceServiceImp;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Handler;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();

    public void start(SolonApp app) {
        if (Utils.isNotEmpty((String)WaterProps.instance.getServer())) {
            long interval;
            String logDefault;
            String server = WaterProps.instance.getServer();
            String configServer = WaterProps.instance.getConfigServer();
            String discoveryServer = WaterProps.instance.getDiscoveryServer();
            String eventServer = WaterProps.instance.getEventServer();
            String logServer = WaterProps.instance.getLogServer();
            CloudProps.LOG_DEFAULT_LOGGER = logDefault = WaterProps.instance.getLogDefault();
            System.setProperty("water.host", server);
            if (Utils.isNotEmpty((String)logDefault)) {
                System.setProperty("water.logger", logDefault);
            }
            if (!server.equals(configServer)) {
                WaterAddress.setConfigApiUrl((String)configServer);
            }
            if (!server.equals(discoveryServer)) {
                WaterAddress.setRegistryApiUrl((String)discoveryServer);
            }
            if (!server.equals(eventServer)) {
                WaterAddress.setMessageApiUrl((String)eventServer);
            }
            if (!server.equals(logServer)) {
                WaterAddress.setLogApiUrl((String)logServer);
            }
            CloudDiscoveryServiceImp discoveryServiceImp = null;
            CloudConfigServiceImp configServiceImp = null;
            CloudEventServiceImp eventServiceImp = null;
            CloudLogServiceImp logServiceImp = null;
            CloudTraceServiceImp traceServiceImp = new CloudTraceServiceImp();
            WaterClient.localHostSet((String)Instance.local().address());
            WaterClient.localServiceSet((String)Instance.local().service());
            WaterSetting.water_trace_id_supplier(traceServiceImp::getTraceId);
            if (WaterProps.instance.getTraceEnable()) {
                CloudManager.register((CloudTraceService)traceServiceImp);
            }
            if (WaterProps.instance.getConfigEnable()) {
                configServiceImp = new CloudConfigServiceImp();
                CloudManager.register((CloudConfigService)configServiceImp);
                if (Solon.cfg().isFilesMode() && configServiceImp.getRefreshInterval() > 0L) {
                    interval = configServiceImp.getRefreshInterval();
                    this.clientTimer.schedule((TimerTask)configServiceImp, interval, interval);
                }
                CloudClient.configLoad((String)WaterProps.instance.getConfigLoadGroup(), (String)WaterProps.instance.getConfigLoadKey());
            }
            if (WaterProps.instance.getDiscoveryEnable()) {
                discoveryServiceImp = new CloudDiscoveryServiceImp();
                CloudManager.register((CloudDiscoveryService)discoveryServiceImp);
                if (Solon.cfg().isFilesMode() && discoveryServiceImp.getRefreshInterval() > 0L) {
                    interval = discoveryServiceImp.getRefreshInterval();
                    this.clientTimer.schedule((TimerTask)discoveryServiceImp, interval, interval);
                }
            }
            if (WaterProps.instance.getLogEnable()) {
                logServiceImp = new CloudLogServiceImp();
                CloudManager.register((CloudLogService)logServiceImp);
            }
            if (WaterProps.instance.getEventEnable()) {
                eventServiceImp = new CloudEventServiceImp();
                CloudManager.register((CloudEventService)eventServiceImp);
                if (discoveryServiceImp != null) {
                    CloudClient.event().attention(EventLevel.instance, "", "water.cache.update", (CloudEventHandler)new HandlerCacheUpdate(discoveryServiceImp));
                }
                if (configServiceImp != null) {
                    CloudClient.event().attention(EventLevel.instance, "", "water.config.update", (CloudEventHandler)new HandlerConfigUpdate(configServiceImp));
                }
                Aop.beanOnloaded(eventServiceImp::subscribe);
            }
            if (WaterProps.instance.getLockEnable()) {
                CloudManager.register((CloudLockService)new CloudLockServiceImp());
            }
            app.http("/run/check/", (Handler)new HandlerCheck());
            app.http("/run/status/", (Handler)new HandlerStatus());
            app.http("/run/stop/", (Handler)new HandlerStop());
            app.http("/msg/receive", (Handler)new HandlerReceive(eventServiceImp));
        }
    }

    public void prestop() throws Throwable {
        if (this.clientTimer != null) {
            this.clientTimer.cancel();
        }
    }
}

