/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.integration.msg;

import org.noear.mlog.Logger;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.water.service.CloudDiscoveryServiceImp;
import org.noear.solon.cloud.model.Event;
import org.noear.weed.WeedConfig;
import org.noear.weed.cache.ICacheServiceEx;

public class HandlerCacheUpdate
implements CloudEventHandler {
    static Logger logger = Logger.get((String)"water_log_upstream");
    CloudDiscoveryServiceImp discoveryService;

    public HandlerCacheUpdate(CloudDiscoveryServiceImp discoveryService) {
        this.discoveryService = discoveryService;
    }

    public boolean handler(Event event) {
        String[] tag_keys;
        for (String tagKey : tag_keys = event.content().split(";")) {
            if (!Utils.isNotEmpty((String)tagKey)) continue;
            this.cacheUpdateHandler0(tagKey);
            this.cacheUpdateHandler1(tagKey);
        }
        return true;
    }

    public void cacheUpdateHandler0(String tag) {
        String[] ss = tag.split(":");
        if ("upstream".equals(ss[0])) {
            String service = ss[1];
            try {
                this.discoveryService.onUpdate(Solon.cfg().appGroup(), service);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error(ss[1], new Object[]{"reload", "", ex});
            }
        }
    }

    public void cacheUpdateHandler1(String tag) {
        if (tag.indexOf(".") > 0) {
            ICacheServiceEx cache;
            String[] ss = tag.split("\\.");
            if (ss.length == 2 && (cache = (ICacheServiceEx)WeedConfig.libOfCache.get(ss[0])) != null) {
                cache.clear(ss[1]);
            }
        } else {
            for (ICacheServiceEx cache : WeedConfig.libOfCache.values()) {
                cache.clear(tag);
            }
        }
    }
}

