/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.model.HandlerEntity;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.water.WaterClient;

public class CloudJobServiceWaterImp
implements CloudJobService {
    public static final CloudJobServiceWaterImp instance = new CloudJobServiceWaterImp();
    public Map<String, HandlerEntity> jobMap = new LinkedHashMap<String, HandlerEntity>();

    public HandlerEntity get(String name) {
        return this.jobMap.get(name);
    }

    public void push() {
        if (this.jobMap.size() == 0) {
            return;
        }
        LinkedHashMap jobs = new LinkedHashMap();
        this.jobMap.forEach((k, v) -> jobs.put(v.getName(), v.getDescription()));
        try {
            WaterClient.job.register(Solon.cfg().appGroup(), Solon.cfg().appName(), jobs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean register(String name, String description, Handler handler) {
        this.jobMap.put(name, new HandlerEntity(name, description, handler));
        TagsMDC.tag0((String)"CloudJob");
        PrintUtil.warn((String)"CloudJob", (Object)("Handler registered name:" + name + ", class:" + handler.getClass().getName()));
        TagsMDC.tag0((String)"");
        return true;
    }

    public boolean isRegistered(String name) {
        return this.jobMap.containsKey(name);
    }
}

