/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.water.WaterProps;
import org.noear.solon.cloud.extend.water.integration.http.HandlerCheck;
import org.noear.solon.cloud.extend.water.integration.http.HandlerJob;
import org.noear.solon.cloud.extend.water.integration.http.HandlerReceive;
import org.noear.solon.cloud.extend.water.integration.http.HandlerStatus;
import org.noear.solon.cloud.extend.water.integration.http.HandlerStop;
import org.noear.solon.cloud.extend.water.integration.msg.HandlerCacheUpdate;
import org.noear.solon.cloud.extend.water.integration.msg.HandlerConfigUpdate;
import org.noear.solon.cloud.extend.water.service.CloudConfigServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudDiscoveryServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudEventServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudJobServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudListServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudLockServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudLogServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudMetricServiceWaterImp;
import org.noear.solon.cloud.extend.water.service.CloudTraceServiceWaterImp;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Handler;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();
    CloudProps cloudProps;

    public void start(SolonApp app) {
        long interval;
        String logDefault;
        if (Utils.isEmpty((String)WaterProps.instance.getServer())) {
            return;
        }
        this.cloudProps = WaterProps.instance;
        String server = this.cloudProps.getServer();
        String configServer = this.cloudProps.getConfigServer();
        String discoveryServer = this.cloudProps.getDiscoveryServer();
        String eventServer = this.cloudProps.getEventServer();
        String logServer = this.cloudProps.getLogServer();
        CloudProps.LOG_DEFAULT_LOGGER = logDefault = this.cloudProps.getLogDefault();
        System.setProperty("water.host", server);
        if (Utils.isNotEmpty((String)logDefault)) {
            System.setProperty("water.logger", logDefault);
        }
        if (!server.equals(configServer)) {
            WaterAddress.setConfigApiUrl((String)configServer);
        }
        if (!server.equals(discoveryServer)) {
            WaterAddress.setRegistryApiUrl((String)discoveryServer);
        }
        if (!server.equals(eventServer)) {
            WaterAddress.setMessageApiUrl((String)eventServer);
        }
        if (!server.equals(logServer)) {
            WaterAddress.setLogApiUrl((String)logServer);
        }
        CloudDiscoveryServiceWaterImp discoveryServiceImp = null;
        CloudConfigServiceWaterImp configServiceImp = null;
        CloudEventServiceWaterImp eventServiceImp = null;
        CloudTraceServiceWaterImp traceServiceImp = new CloudTraceServiceWaterImp();
        CloudMetricServiceWaterImp metricServiceImp = new CloudMetricServiceWaterImp();
        WaterClient.localHostSet((String)Instance.local().address());
        WaterClient.localServiceSet((String)Instance.local().service());
        WaterSetting.water_trace_id_supplier(() -> ((CloudTraceServiceWaterImp)traceServiceImp).getTraceId());
        if (this.cloudProps.getTraceEnable()) {
            CloudManager.register((CloudTraceService)traceServiceImp);
        }
        if (this.cloudProps.getMetricEnable()) {
            CloudManager.register((CloudMetricService)metricServiceImp);
        }
        if (this.cloudProps.getConfigEnable()) {
            configServiceImp = new CloudConfigServiceWaterImp(this.cloudProps);
            CloudManager.register((CloudConfigService)configServiceImp);
            if (Solon.cfg().isFilesMode() && configServiceImp.getRefreshInterval() > 0L) {
                interval = configServiceImp.getRefreshInterval();
                this.clientTimer.schedule((TimerTask)configServiceImp, interval, interval);
            }
            CloudClient.configLoad((String)this.cloudProps.getConfigLoad());
            CloudClient.configLoad((String)this.cloudProps.getConfigLoadGroup(), (String)this.cloudProps.getConfigLoadKey());
        }
        if (this.cloudProps.getDiscoveryEnable()) {
            discoveryServiceImp = new CloudDiscoveryServiceWaterImp(this.cloudProps);
            CloudManager.register((CloudDiscoveryService)discoveryServiceImp);
            if (discoveryServiceImp.getRefreshInterval() > 0L) {
                interval = discoveryServiceImp.getRefreshInterval();
                this.clientTimer.schedule((TimerTask)discoveryServiceImp, interval, interval);
            }
        }
        if (this.cloudProps.getLogEnable()) {
            CloudManager.register((CloudLogService)new CloudLogServiceWaterImp(this.cloudProps));
        }
        if (this.cloudProps.getEventEnable()) {
            String receive = this.getEventReceive();
            if (receive != null && receive.startsWith("@") && CloudClient.config() != null) {
                Config cfg = CloudClient.config().pull(Solon.cfg().appGroup(), receive.substring(1));
                if (cfg == null || Utils.isEmpty((String)cfg.value())) {
                    throw new IllegalArgumentException("Configuration " + receive + " does not exist");
                }
                this.setEventReceive(cfg.value());
            }
            eventServiceImp = new CloudEventServiceWaterImp(this.cloudProps);
            CloudManager.register((CloudEventServicePlus)eventServiceImp);
            if (discoveryServiceImp != null) {
                eventServiceImp.attention(EventLevel.instance, "", "", "water.cache.update", new HandlerCacheUpdate(discoveryServiceImp));
            }
            if (configServiceImp != null) {
                eventServiceImp.attention(EventLevel.instance, "", "", "water.config.update", new HandlerConfigUpdate(configServiceImp));
            }
            Aop.beanOnloaded(eventServiceImp::subscribe);
        }
        if (this.cloudProps.getLockEnable()) {
            CloudManager.register((CloudLockService)new CloudLockServiceWaterImp());
        }
        if (this.cloudProps.getListEnable()) {
            CloudManager.register((CloudListService)new CloudListServiceWaterImp());
        }
        if (this.cloudProps.getJobEnable()) {
            CloudManager.register((CloudJobService)CloudJobServiceWaterImp.instance);
            Aop.beanOnloaded(() -> CloudJobServiceWaterImp.instance.push());
        }
        if (this.cloudProps.getJobEnable()) {
            app.http("/run/job/", (Handler)new HandlerJob());
        }
        app.http("/run/check/", (Handler)new HandlerCheck());
        app.http("/run/status/", (Handler)new HandlerStatus());
        app.http("/run/stop/", (Handler)new HandlerStop());
        app.http("/msg/receive", (Handler)new HandlerReceive(eventServiceImp));
    }

    public void prestop() throws Throwable {
        if (this.clientTimer != null) {
            this.clientTimer.cancel();
        }
    }

    public String getEventSeal() {
        return this.cloudProps.getProp("event.seal");
    }

    public String getEventReceive() {
        return this.cloudProps.getProp("event.receive");
    }

    public void setEventReceive(String value) {
        this.cloudProps.setProp("event.receive", value);
    }
}

