/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.integration.msg;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.extend.water.service.CloudDiscoveryServiceWaterImp;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.logging.utils.TagsMDC;
import org.noear.weed.WeedConfig;
import org.noear.weed.cache.ICacheServiceEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerCacheUpdate
implements CloudEventHandler {
    static Logger logger = LoggerFactory.getLogger((String)"water_log_upstream");
    CloudDiscoveryServiceWaterImp discoveryService;

    public HandlerCacheUpdate(CloudDiscoveryServiceWaterImp discoveryService) {
        this.discoveryService = discoveryService;
    }

    public boolean handler(Event event) {
        String[] tagKeyAry;
        for (String tagKey : tagKeyAry = event.content().split(";")) {
            if (!Utils.isNotEmpty((String)tagKey)) continue;
            this.cacheUpdateHandler0(tagKey);
            this.cacheUpdateHandler1(tagKey);
        }
        return true;
    }

    public void cacheUpdateHandler0(String tagKey) {
        String[] ss = null;
        ss = tagKey.contains("::") ? tagKey.split("::") : tagKey.split(":");
        if ("upstream".equals(ss[0])) {
            String service = ss[1];
            try {
                this.discoveryService.onUpdate("", service);
            }
            catch (Exception ex) {
                TagsMDC.tag0((String)ss[1]);
                TagsMDC.tag1((String)"reload");
                logger.error("{}", (Throwable)ex);
            }
        }
    }

    public void cacheUpdateHandler1(String tag) {
        if (tag.indexOf(".") > 0) {
            ICacheServiceEx cache;
            String[] ss = tag.split("\\.");
            if (ss.length == 2 && (cache = (ICacheServiceEx)WeedConfig.libOfCache.get(ss[0])) != null) {
                cache.clear(ss[1]);
            }
        } else {
            for (ICacheServiceEx cache : WeedConfig.libOfCache.values()) {
                cache.clear(tag);
            }
        }
    }
}

