/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.solon_plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XPlugin;
import org.noear.water.WaterClient;
import org.noear.water.model.MessageM;
import org.noear.water.solon_plugin.IPUtils;
import org.noear.water.solon_plugin.XMessageHandler;
import org.noear.water.solon_plugin.XWaterAdapterBase;
import org.noear.weed.WeedConfig;
import org.noear.weed.cache.ICacheServiceEx;

public abstract class XWaterAdapter
extends XWaterAdapterBase
implements XPlugin {
    protected static XWaterAdapter _global;
    private Map<String, XMessageHandler> _router;

    public static XWaterAdapter global() {
        return _global;
    }

    public Map<String, XMessageHandler> router() {
        return this._router;
    }

    public String msg_receiver_url() {
        return null;
    }

    public XWaterAdapter() {
        super(XApp.cfg().argx(), XApp.global().port());
        _global = this;
    }

    public void start(XApp app) {
        app.all(this.service_check_path, this::handle);
        app.all(this.msg_receiver_path, this::handle);
    }

    @Override
    protected void onInit() {
        this._router = new HashMap<String, XMessageHandler>();
        this.registerService();
        this.messageListening(this._router);
        this.messageSubscribe();
        this.initWeed();
    }

    public int user_puid() {
        if (XContext.current() != null) {
            String tmp = (String)XContext.current().attr("user_puid", (Object)"0");
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    public String user_name() {
        if (XContext.current() != null) {
            return (String)XContext.current().attr("user_name", null);
        }
        return null;
    }

    protected void initWeed() {
        Class clz = XUtil.loadClass((String)"org.noear.bcf.BcfClient");
        if (clz == null) {
            WeedConfig.onExecuteAft(cmd -> WaterClient.Track.track(this.service_name(), cmd, 1000L));
        } else {
            WeedConfig.onExecuteAft(cmd -> {
                System.out.println(cmd.text);
                if (cmd.isLog < 0) {
                    return;
                }
                if (this.user_name() == null) {
                    return;
                }
                XContext context = XContext.current();
                String sqlUp = cmd.text.toUpperCase();
                String chkUp = "User_Id=? AND Pass_Wd=? AND Is_Disabled=0".toUpperCase();
                if (cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.indexOf("INSERT INTO ") >= 0 || sqlUp.indexOf("UPDATE ") >= 0 || sqlUp.indexOf("DELETE ") >= 0 || sqlUp.indexOf(chkUp) >= 0) {
                    WaterClient.Track.track(this.service_name(), cmd, context.userAgent(), context.path(), this.user_puid() + "." + this.user_name(), IPUtils.getIP(context));
                }
            });
        }
    }

    public void messageListening(Map<String, XMessageHandler> map) {
    }

    public void messageSubscribeHandler() {
        if (this._router.size() == 0) {
            return;
        }
        ArrayList _list = new ArrayList();
        this._router.keySet().forEach(t -> {
            if (!t.startsWith("water.")) {
                _list.add(t);
            }
        });
        String[] topics = new String[_list.size()];
        _list.toArray(topics);
        try {
            this.messageSubscribeTopic(this.msg_receiver_url(), 0, topics);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean messageReceiveHandler(MessageM msg) throws Exception {
        XMessageHandler handler = this._router.get(msg.topic);
        if (handler == null) {
            return true;
        }
        return handler.handler(msg);
    }

    @Override
    public void cacheUpdateHandler(String tag) {
        super.cacheUpdateHandler(tag);
        for (ICacheServiceEx cache : WeedConfig.libOfCache.values()) {
            cache.remove(tag);
        }
    }
}

