/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.solon_plugin;

import java.io.IOException;
import org.noear.snack.ONode;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XMap;
import org.noear.water.WaterAdapter;
import org.noear.water.WaterClient;
import org.noear.water.log.Logger;
import org.noear.water.log.WaterLogger;
import org.noear.water.solon_plugin.IPUtils;
import org.noear.water.solon_plugin.XWaterUpstream;
import org.noear.water.utils.TextUtils;

abstract class XWaterAdapterBase
extends WaterAdapter {
    static Logger logger = new WaterLogger("water_log_upstream", XWaterAdapterBase.class);
    XMap service_args;
    private String _localHost;
    private String _note = "";

    public XWaterAdapterBase(XMap args, int port) {
        this.service_args = args;
        this.service_port = port;
        this.service_check_path = "/run/check/";
        this.service_stop_path = "/run/stop/";
        this.msg_receiver_path = "/msg/receive";
        this.onInit();
    }

    protected void onInit() {
        this.registerService();
        this.messageSubscribe();
    }

    public String localHost() {
        return this._localHost;
    }

    protected void registerService() {
        WaterClient.localHost = this._localHost = XWaterAdapterBase.getLocalAddress((int)this.service_port);
        XWaterUpstream._consumer = this.service_name();
        XWaterUpstream._consumer_address = this._localHost;
        if (this.service_args == null || this.service_args.size() == 0) {
            this._note = "";
        } else {
            ONode tmp = ONode.load((Object)this.service_args);
            tmp.remove("server.port");
            this._note = tmp.toJson();
            if (this._note.length() < 3) {
                this._note = "";
            }
        }
        if (this.service_port > 0) {
            WaterClient.Registry.add(this.service_name(), this._localHost, this._note, this.service_check_path, 0, this.alarm_mobile(), this.is_unstable());
        } else {
            WaterClient.Registry.add(this.service_name(), this._localHost, this._note, this.service_check_path, 1, this.alarm_mobile(), this.is_unstable());
        }
    }

    public void stateSet(boolean enabled) {
        if (!TextUtils.isEmpty((CharSequence)this._localHost)) {
            WaterClient.Registry.set(this.service_name(), this._localHost, this._note, enabled);
        }
    }

    public void cacheUpdateHandler(String tag) {
        XWaterUpstream tmp;
        super.cacheUpdateHandler(tag);
        String[] ss = tag.split(":");
        if ("upstream".equals(ss[0]) && (tmp = XWaterUpstream.getOnly(ss[1])) != null) {
            try {
                tmp.reload();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error(ss[1], "reload", "", (Object)ex);
            }
        }
    }

    public String serviceCheck(XContext cxt) throws Exception {
        String ups = cxt.param("upstream");
        if (!TextUtils.isEmpty((CharSequence)ups)) {
            ONode odata = new ONode().asObject();
            if ("*".equals(ups)) {
                XWaterUpstream._map.forEach((k, v) -> {
                    ONode n = odata.get(k);
                    n.set("service", k);
                    ONode nl = n.get("upstream").asArray();
                    v._list.forEach(s -> nl.add(s));
                });
            } else {
                XWaterUpstream v2 = XWaterUpstream.getOnly(ups);
                if (v2 != null) {
                    ONode n = odata.get(ups);
                    n.set("service", (Object)ups);
                    ONode nl = n.get("upstream").asArray();
                    v2._list.forEach(s -> nl.add(s));
                }
            }
            return odata.toJson();
        }
        return "{\"code\":1}";
    }

    public String messageReceive(XContext cxt) throws Exception {
        return this.doMessageReceive(k -> cxt.param(k));
    }

    public void handle(XContext context) throws IOException {
        String path = context.path();
        String text = "";
        try {
            if (this.service_check_path.equals(path)) {
                text = this.serviceCheck(context);
            } else if (this.service_stop_path.equals(path)) {
                String ip = IPUtils.getIP(context);
                if (WaterClient.Whitelist.existsOfMasterIp(ip)) {
                    this.stateSet(false);
                    XApp.stop();
                    text = "OK";
                } else {
                    text = ip + ",not is whitelist!";
                }
            } else if (this.msg_receiver_path.equals(path)) {
                text = this.messageReceive(context);
            }
        }
        catch (Exception ex) {
            text = XUtil.getFullStackTrace((Throwable)ex);
            ex.printStackTrace();
        }
        context.output(text);
    }
}

