/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.solon_plugin;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.XApp;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XRender;
import org.noear.solonclient.HttpUpstream;
import org.noear.solonclient.XProxy;
import org.noear.water.solon_plugin.XWaterUpstream;
import org.noear.water.utils.TextUtils;

public class XWaterGateway
implements XHandler,
XRender {
    Map<String, HttpUpstream> router = new HashMap<String, HttpUpstream>();

    public XWaterGateway() {
        XMap map = XApp.cfg().getXmap("water.gateway");
        map.forEach((alias, service) -> {
            String url;
            if (XApp.cfg().isDebugMode() && (url = System.getProperty("water.remoting-debug." + service)) != null) {
                this.add((String)alias, s -> url);
                return;
            }
            this.add((String)alias, (String)service);
        });
    }

    protected void add(String alias, String service) {
        this.router.put(alias, XWaterUpstream.get(service));
    }

    protected void add(String alias, HttpUpstream upstream) {
        this.router.put(alias, upstream);
    }

    public void handle(XContext ctx) throws Throwable {
        String path = ctx.path();
        if (path.length() < 3) {
            ctx.status(404);
            return;
        }
        String fun = null;
        String alias = ctx.header("_service");
        if (TextUtils.isEmpty((CharSequence)alias)) {
            alias = ctx.param("_service");
        }
        if (TextUtils.isEmpty((CharSequence)alias)) {
            String[] paths = path.substring(1).split("/");
            if (paths.length < 2) {
                ctx.status(404);
                return;
            }
            alias = paths[0];
            int idx = path.indexOf("/", 2) + 1;
            fun = path.substring(idx);
        } else {
            fun = path;
        }
        HttpUpstream upstream = this.router.get(alias);
        if (upstream == null) {
            ctx.status(404);
            return;
        }
        String rst = new XProxy(null).url(upstream.getTarget(alias), fun).call((Map)ctx.headerMap(), (Map)ctx.paramMap()).getString();
        this.render(rst, ctx);
    }

    public void render(Object obj, XContext ctx) throws Throwable {
        ctx.output(obj.toString());
    }
}

