/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.solon_plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.XApp;
import org.noear.solonclient.HttpUpstream;
import org.noear.solonclient.XProxy;
import org.noear.solonclient.annotation.XClient;
import org.noear.water.WaterClient;
import org.noear.water.model.DiscoverM;
import org.noear.water.model.DiscoverTargetM;
import org.noear.water.utils.TextUtils;

public class XWaterUpstream
implements HttpUpstream {
    private final String TAG_SERVER = "{server}";
    private String _service;
    private DiscoverM _model;
    private int _upstream_val = 0;
    private int _count;
    protected final List<String> _list = new ArrayList<String>();
    private boolean _use_url;
    protected static String _consumer;
    protected static String _consumer_address;
    protected static final Map<String, XWaterUpstream> _map;

    private XWaterUpstream(String service) {
        this._service = service;
    }

    public static XWaterUpstream get(String service) {
        if (_map.containsKey(service)) {
            return _map.get(service);
        }
        XWaterUpstream tmp = new XWaterUpstream(service);
        tmp.reload();
        _map.put(service, tmp);
        return tmp;
    }

    protected static XWaterUpstream getOnly(String service) {
        return _map.get(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (_consumer == null) {
            _consumer = "";
        }
        if (_consumer_address == null) {
            _consumer_address = "";
        }
        DiscoverM mod = WaterClient.Registry.discover(this._service, _consumer, _consumer_address);
        String string = this._service;
        synchronized (string) {
            this.doLoad(mod);
        }
    }

    public String name() {
        return this._service;
    }

    public String policy() {
        if (this._model == null) {
            return null;
        }
        return this._model.policy;
    }

    public List<String> nodes() {
        return Collections.unmodifiableList(this._list);
    }

    private void doLoad(DiscoverM model) {
        if (model == null || TextUtils.isEmpty((CharSequence)model.policy)) {
            return;
        }
        this._model = model;
        if (this._model.url != null) {
            if (this._model.url.indexOf("://") > 0) {
                this._use_url = true;
            }
        } else {
            this._model.url = "";
        }
        this._list.clear();
        for (DiscoverTargetM m : this._model.list) {
            int sev_wgt = m.weight;
            String sev_url = m.protocol + "://" + m.address;
            if (this._model.url.contains("{server}")) {
                sev_url = this._model.url.replace("{server}", sev_url);
            }
            while (sev_wgt > 0) {
                this._list.add(sev_url);
                --sev_wgt;
            }
        }
        this._count = this._list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        if (this._use_url) {
            return this._model.url;
        }
        if (this._count == 0) {
            return null;
        }
        String string = this._service;
        synchronized (string) {
            if (this._upstream_val == 9999999) {
                this._upstream_val = 0;
            }
            ++this._upstream_val;
            int idx = this._upstream_val % this._count;
            return this._list.get(idx);
        }
    }

    public String getTarget(String name) {
        return this.get();
    }

    public static <T> T xclient(Class<?> clz) {
        String url;
        XClient c_meta = clz.getAnnotation(XClient.class);
        if (c_meta == null) {
            throw new RuntimeException("No xclient annotation");
        }
        String c_sev = c_meta.value();
        if (TextUtils.isEmpty((CharSequence)c_sev)) {
            throw new RuntimeException("XClient no name");
        }
        if (c_sev.indexOf(":") > 0) {
            c_sev = c_sev.split(":")[0];
        }
        XWaterUpstream upstream = null;
        if (XApp.cfg().isDebugMode() && (url = System.getProperty("water.remoting-debug." + c_sev)) != null) {
            upstream = s -> url;
        }
        if (upstream == null) {
            upstream = XWaterUpstream.get(c_sev);
        }
        return XWaterUpstream.xclient(clz, upstream);
    }

    public static <T> T xclient(Class<?> clz, HttpUpstream upstream) {
        if (_consumer == null) {
            _consumer = "";
        }
        if (_consumer_address == null) {
            _consumer_address = "";
        }
        return (T)new XProxy().headerAdd("_from", _consumer + "@" + _consumer_address).upstream(upstream).create(clz);
    }

    static {
        _map = new ConcurrentHashMap<String, XWaterUpstream>();
    }
}

