/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration.solon;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.water.WaterClient;
import org.noear.water.WaterProps;
import org.noear.water.WaterSetting;
import org.noear.water.annotation.Water;
import org.noear.water.annotation.WaterConfig;
import org.noear.water.annotation.WaterMessage;
import org.noear.water.dso.ConfigHandler;
import org.noear.water.dso.MessageHandler;
import org.noear.water.integration.solon.WaterAdapter;
import org.noear.water.integration.solon.WaterAdapterImp;
import org.noear.water.integration.solon.WaterBeanInjector;
import org.noear.water.integration.solon.WaterUpstreamFactoryImp;
import org.noear.water.utils.TextUtils;
import org.noear.weed.xml.XmlSqlLoader;

public class XPluginImp
implements Plugin {
    Map<String, MessageHandler> _router = new HashMap<String, MessageHandler>();

    public void start(SolonApp app) {
        XmlSqlLoader.tryLoad();
        Bridge.upstreamFactorySet((LoadBalance.Factory)new WaterUpstreamFactoryImp());
        if (app.port() > 0 && WaterProps.service_name() != null) {
            app.plug((Plugin)new WaterAdapterImp());
        }
        if (!TextUtils.isEmpty((CharSequence)WaterProps.service_config())) {
            String[] ss;
            for (String s : ss = WaterProps.service_config().split(",")) {
                String tagKey = s.trim();
                if (tagKey.startsWith("@")) {
                    tagKey = tagKey.substring(1);
                }
                String keyTmp = "*";
                if (tagKey.indexOf("/") > 0) {
                    keyTmp = tagKey.split("/")[0];
                }
                String tag = tagKey.split("/")[0];
                String key = keyTmp;
                WaterClient.Config.getProperties(tag).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (key.equals("*") || k.toString().indexOf(key) >= 0) {
                        Solon.cfg().put(k, v);
                    }
                }));
            }
        }
        Aop.context().beanInjectorAdd(Water.class, (BeanInjector)WaterBeanInjector.instance);
        Aop.context().beanBuilderAdd(WaterMessage.class, (clz, wrap, anno) -> {
            String topic;
            if (MessageHandler.class.isAssignableFrom(clz) && !TextUtils.isEmpty((CharSequence)(topic = anno.value()))) {
                this._router.put(topic, (MessageHandler)wrap.raw());
            }
        });
        Aop.context().beanBuilderAdd(WaterConfig.class, (clz, wrap, anno) -> {
            String tag;
            if (ConfigHandler.class.isAssignableFrom(clz) && !TextUtils.isEmpty((CharSequence)(tag = anno.value()))) {
                WaterClient.Config.subscribe(tag, (ConfigHandler)wrap.raw());
            }
        });
        Aop.context().beanOnloaded(() -> {
            if (WaterAdapter.global() != null && this._router.size() > 0) {
                WaterAdapter.global().router().putAll(this._router);
                WaterAdapter.global().messageSubscribeHandler();
                this._router.clear();
            }
        });
        WaterSetting.water_trace_id_supplier(() -> {
            Context ctx = Context.current();
            if (ctx == null) {
                return "";
            }
            String trace_id = ctx.header("Water-Trace-Id");
            if (TextUtils.isEmpty((CharSequence)trace_id)) {
                trace_id = Utils.guid();
                ctx.headerMap().put("Water-Trace-Id", (Object)trace_id);
            }
            return trace_id;
        });
    }

    public void stop() throws Throwable {
        WaterSetting.libOfDb.clear();
        WaterSetting.libOfRd.clear();
        WaterSetting.libOfCache.clear();
    }
}

