/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration.solon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;
import org.noear.water.dso.MessageHandler;
import org.noear.water.integration.solon.WaterAdapterBase;
import org.noear.water.log.Level;
import org.noear.water.log.WaterLogger;
import org.noear.water.model.MessageM;
import org.noear.water.utils.IPUtils;
import org.noear.water.utils.TextUtils;
import org.noear.weed.WeedConfig;
import org.noear.weed.cache.ICacheServiceEx;

public abstract class WaterAdapter
extends WaterAdapterBase
implements Plugin {
    protected static WaterAdapter _global;
    private Map<String, MessageHandler> _router;

    public static WaterAdapter global() {
        return _global;
    }

    public Map<String, MessageHandler> router() {
        return this._router;
    }

    public String msg_receiver_url() {
        return null;
    }

    @Override
    public boolean is_unstable() {
        return Solon.cfg().isDriftMode() || Solon.cfg().isFilesMode();
    }

    public WaterAdapter() {
        super(Solon.cfg().argx(), Solon.global().port());
        _global = this;
        Utils.loadClass((String)"com.mysql.jdbc.Driver");
        Utils.loadClass((String)"com.mysql.cj.jdbc.Driver");
    }

    public void start(SolonApp app) {
        Aop.context().beanOnloaded(() -> {
            app.all(this.service_status_path, this::handle);
            app.all(this.service_check_path, this::handle);
            app.all(this.service_stop_path, this::handle);
            app.all(this.msg_receiver_path, this::handle);
        });
    }

    @Override
    protected void onInit() {
        this._router = new HashMap<String, MessageHandler>();
        this.registerService();
        this.messageListening(this._router);
        this.messageSubscribe();
        this.configSubscribe();
        this.initWeed();
    }

    private void configSubscribe() {
        if (!TextUtils.isEmpty((CharSequence)this.service_tag())) {
            WaterClient.Config.subscribe(this.service_tag(), cfgSet -> {
                int packetSize;
                int interval;
                int level;
                cfgSet.sync();
                int gzip = Solon.cfg().getInt("water.log.pipeline.gzip", -1);
                if (gzip > -1) {
                    WaterSetting.water_logger_gzip((gzip == 1 ? 1 : 0) != 0);
                }
                if ((level = Solon.cfg().getInt("water.log.pipeline.level", -1)) > -1) {
                    WaterLogger.setLevel(Level.of((int)level));
                }
                if ((interval = Solon.cfg().getInt("water.log.pipeline.interval", -1)) > -1) {
                    WaterLogger.setInterval(interval);
                }
                if ((packetSize = Solon.cfg().getInt("water.log.pipeline.packetSize", -1)) > -1) {
                    WaterLogger.setPacketSize(packetSize);
                }
            });
        }
    }

    public int user_puid() {
        if (Context.current() != null) {
            String tmp = (String)Context.current().attr("user_puid", (Object)"0");
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    public String user_name() {
        if (Context.current() != null) {
            return (String)Context.current().attr("user_name", null);
        }
        return null;
    }

    protected void initWeed() {
        Class bcfClz = Utils.loadClass((String)"org.noear.bcf.BcfClient");
        boolean isDebugMode = Solon.cfg().isDebugMode() || Solon.cfg().isFilesMode();
        boolean isWeedStyle2 = "text2".equals(Solon.cfg().get("water.weed.log.style"));
        if (bcfClz == null) {
            WeedConfig.onExecuteAft(cmd -> {
                if (isDebugMode) {
                    if (isWeedStyle2) {
                        System.out.println(cmd.toSqlString());
                    } else {
                        System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                    }
                }
                WaterClient.Track.track(this.service_name(), cmd, 1000L);
            });
        } else {
            WeedConfig.onExecuteAft(cmd -> {
                if (isDebugMode) {
                    if (isWeedStyle2) {
                        System.out.println(cmd.text2());
                    } else {
                        System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                    }
                }
                if (cmd.isLog < 0) {
                    return;
                }
                if (this.user_name() == null) {
                    return;
                }
                Context context = Context.current();
                String sqlUp = cmd.text.toUpperCase();
                String chkUp = "User_Id=? AND Pass_Wd=? AND Is_Disabled=0".toUpperCase();
                if (cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.indexOf("INSERT INTO ") >= 0 || sqlUp.indexOf("UPDATE ") >= 0 || sqlUp.indexOf("DELETE ") >= 0 || sqlUp.indexOf(chkUp) >= 0) {
                    WaterClient.Track.track(this.service_name(), cmd, context.userAgent(), context.path(), this.user_puid() + "." + this.user_name(), IPUtils.getIP((Context)context));
                }
            });
        }
    }

    public void messageListening(Map<String, MessageHandler> map) {
    }

    @Override
    public void messageSubscribeHandler() {
        if (this._router.size() == 0) {
            return;
        }
        ArrayList _list = new ArrayList();
        this._router.keySet().forEach(t -> {
            if (!t.startsWith("water.")) {
                _list.add(t);
            }
        });
        String[] topics = new String[_list.size()];
        _list.toArray(topics);
        this.messageSubscribeTopic(topics);
    }

    public void messageSubscribeTopic(String ... topics) {
        try {
            this.messageSubscribeTopic(this.msg_receiver_url(), 0, topics);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean messageReceiveHandler(MessageM msg) throws Throwable {
        MessageHandler handler = this._router.get(msg.topic);
        if (handler == null) {
            return true;
        }
        return handler.handler(msg);
    }

    @Override
    public void cacheUpdateHandler(String tag) {
        super.cacheUpdateHandler(tag);
        if (tag.indexOf(".") > 0) {
            ICacheServiceEx cache;
            String[] ss = tag.split("\\.");
            if (ss.length == 2 && (cache = (ICacheServiceEx)WeedConfig.libOfCache.get(ss[0])) != null) {
                cache.clear(ss[1]);
            }
        } else {
            for (ICacheServiceEx cache : WeedConfig.libOfCache.values()) {
                cache.clear(tag);
            }
        }
    }
}

