/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration.solon;

import java.io.IOException;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.noear.water.WaterClient;
import org.noear.water.integration.solon.AbstractWaterAdapter;
import org.noear.water.integration.solon.WaterAdapter;
import org.noear.water.integration.solon.WaterUpstream;
import org.noear.water.log.Logger;
import org.noear.water.log.WaterLogger;
import org.noear.water.utils.IPUtils;
import org.noear.water.utils.RuntimeStatus;
import org.noear.water.utils.RuntimeUtils;
import org.noear.water.utils.TextUtils;
import org.noear.water.utils.ext.Fun1;

abstract class WaterAdapterBase
extends AbstractWaterAdapter {
    static Logger logger = WaterLogger.get("water_log_upstream", WaterAdapterBase.class);
    NvMap service_args;
    private String _localHost;
    private String _note = "";

    public WaterAdapterBase(NvMap args, int port) {
        this.service_args = args;
        this.service_port = port;
        this.service_status_path = "/run/status/";
        this.service_check_path = "/run/check/";
        this.service_stop_path = "/run/stop/";
        this.msg_receiver_path = "/msg/receive";
        this.onInit();
    }

    protected void onInit() {
        this.registerService();
        this.messageSubscribe();
    }

    @Override
    public String localHost() {
        return this._localHost;
    }

    @Override
    protected void registerService() {
        this._localHost = WaterAdapterBase.getLocalAddress(this.service_port);
        WaterClient.localHostSet((String)this._localHost);
        WaterClient.localServiceSet((String)this.service_name());
        if (this.service_args == null || this.service_args.size() == 0) {
            this._note = "";
        } else {
            ONode tmp = ONode.load((Object)this.service_args);
            tmp.remove("server.port");
            this._note = tmp.toJson();
            if (this._note.length() < 3) {
                this._note = "";
            }
        }
        String code_location = Solon.cfg().sourceLocation().getPath();
        if (this.service_port > 0) {
            WaterClient.Registry.register(this.service_name(), this._localHost, this._note, this.service_check_path, 0, this.alarm_mobile(), code_location, this.is_unstable());
        } else {
            WaterClient.Registry.register(this.service_name(), this._localHost, this._note, this.service_check_path, 1, this.alarm_mobile(), code_location, this.is_unstable());
        }
    }

    public void stateSet(boolean enabled) {
        if (!TextUtils.isEmpty((CharSequence)this._localHost)) {
            WaterClient.Registry.set(this.service_name(), this._localHost, this._note, enabled);
        }
    }

    @Override
    public void cacheUpdateHandler(String tag) {
        WaterUpstream tmp;
        super.cacheUpdateHandler(tag);
        String[] ss = tag.split(":");
        if ("upstream".equals(ss[0]) && (tmp = WaterUpstream.getOnly(ss[1])) != null) {
            try {
                tmp.reload();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error(ss[1], "reload", "", (Object)ex);
            }
        }
    }

    public String serviceCheck(Context cxt) {
        String ups = cxt.param("upstream");
        if (!TextUtils.isEmpty((CharSequence)ups)) {
            ONode odata = new ONode().asObject();
            if ("*".equals(ups)) {
                WaterUpstream._map.forEach((k, v) -> {
                    ONode n = odata.get(k);
                    n.set("service", k);
                    ONode nl = n.get("upstream").asArray();
                    v._nodes.forEach(s -> nl.add(s));
                });
            } else {
                WaterUpstream v2 = WaterUpstream.getOnly(ups);
                if (v2 != null) {
                    ONode n = odata.get(ups);
                    n.set("service", (Object)ups);
                    n.set("agent", (Object)v2.agent());
                    n.set("policy", (Object)v2.policy());
                    ONode nl = n.get("upstream").asArray();
                    v2._nodes.forEach(s -> nl.add(s));
                }
            }
            return odata.toJson();
        }
        return "{\"code\":1}";
    }

    public String messageReceive(Context cxt) throws Throwable {
        return this.doMessageReceive((Fun1<String, String>)((Fun1)k -> cxt.param(k)));
    }

    public void handle(Context ctx) throws IOException {
        String path = ctx.path();
        String text = "";
        try {
            if (this.service_check_path.equals(path)) {
                text = this.serviceCheck(ctx);
            } else if (this.service_stop_path.equals(path)) {
                String ip = IPUtils.getIP((Context)ctx);
                if (WaterClient.Whitelist.existsOfMasterIp(ip)) {
                    this.stateSet(false);
                    Solon.stop();
                    text = "OK";
                } else {
                    text = ip + ",not is whitelist!";
                }
            } else if (this.service_status_path.equals(path)) {
                String ip = IPUtils.getIP((Context)ctx);
                if (WaterClient.Whitelist.existsOfMasterIp(ip)) {
                    RuntimeStatus rs = RuntimeUtils.getStatus();
                    rs.name = WaterAdapter.global().service_name();
                    rs.address = WaterAdapter.global().localHost();
                    text = ONode.stringify((Object)rs);
                } else {
                    text = ip + ",not is whitelist!";
                }
            } else if (this.msg_receiver_path.equals(path)) {
                text = this.messageReceive(ctx);
            }
        }
        catch (Throwable ex) {
            text = Utils.getFullStackTrace((Throwable)ex);
            ex.printStackTrace();
        }
        ctx.output(text);
    }
}

