/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration.solon;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.noear.nami.Nami;
import org.noear.nami.common.Result;
import org.noear.solon.Solon;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.water.integration.solon.WaterUpstream;
import org.noear.water.utils.TextUtils;

public class WaterGateway
implements Handler {
    Map<String, LoadBalance> router = new HashMap<String, LoadBalance>();

    public WaterGateway() {
        NvMap map = Solon.cfg().getXmap("water.gateway");
        map.forEach((service, alias) -> {
            String url;
            if (Solon.cfg().isDebugMode() && (url = System.getProperty("water.remoting-debug." + service)) != null) {
                this.add((String)alias, () -> url);
                return;
            }
            if (!this.router.containsKey(alias)) {
                this.add((String)alias, (String)service);
            }
        });
    }

    protected void add(String alias, String service) {
        this.router.put(alias, WaterUpstream.get(service));
    }

    protected void add(String alias, LoadBalance upstream) {
        this.router.put(alias, upstream);
    }

    public void handle(Context ctx) throws Throwable {
        String path = ctx.path();
        if (path.length() < 3) {
            ctx.status(404);
            return;
        }
        String fun = null;
        String alias = ctx.header("_service");
        if (TextUtils.isEmpty((CharSequence)alias)) {
            alias = ctx.param("_service");
        }
        if (TextUtils.isEmpty((CharSequence)alias)) {
            String[] paths = path.substring(1).split("/");
            if (paths.length < 2) {
                ctx.status(404);
                return;
            }
            alias = paths[0];
            int idx = path.indexOf("/", 2) + 1;
            fun = path.substring(idx);
        } else {
            fun = path;
        }
        LoadBalance upstream = this.router.get(alias);
        if (upstream == null) {
            ctx.statusSet(404);
            return;
        }
        Result rst = new Nami().url(upstream.getServer(), fun).call(this.headers(ctx), (Map)ctx.paramMap()).result();
        this.renderDo(rst, ctx);
    }

    protected Map<String, String> headers(Context ctx) {
        return null;
    }

    protected void renderDo(Result rst, Context ctx) throws Throwable {
        rst.headers().forEach(kv -> ctx.headerSet((String)kv.getKey(), (String)kv.getValue()));
        ctx.output((InputStream)new ByteArrayInputStream(rst.body()));
    }
}

