/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration.solon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.core.LoadBalance;
import org.noear.water.WaterClient;
import org.noear.water.model.DiscoverM;
import org.noear.water.model.DiscoverTargetM;
import org.noear.water.utils.HttpUtils;
import org.noear.water.utils.TextUtils;

public class WaterUpstream
implements LoadBalance {
    private final String TAG_SERVER = "{server}";
    private String _service;
    private DiscoverM _cfg;
    private int _polling_val = 0;
    protected List<String> _nodes = new ArrayList<String>();
    private int _nodes_count;
    private boolean _enable_agent;
    private String _backup_server;
    protected static final Map<String, WaterUpstream> _map = new ConcurrentHashMap<String, WaterUpstream>();

    private WaterUpstream(String service) {
        this._service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaterUpstream get(String service) {
        WaterUpstream tmp = _map.get(service);
        if (tmp == null) {
            String string = service.intern();
            synchronized (string) {
                tmp = _map.get(service);
                if (tmp == null) {
                    tmp = new WaterUpstream(service).loadDo(false);
                    _map.put(service, tmp);
                }
            }
        }
        return tmp;
    }

    protected static WaterUpstream getOnly(String service) {
        return _map.get(service);
    }

    public WaterUpstream reload() {
        return this.loadDo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WaterUpstream loadDo(boolean lock) {
        DiscoverM cfg = WaterClient.Registry.discover(this._service, WaterClient.localService(), WaterClient.localHost());
        if (lock) {
            String string = this._service.intern();
            synchronized (string) {
                this.loadDo0(cfg);
            }
        } else {
            this.loadDo0(cfg);
        }
        return this;
    }

    private void loadDo0(DiscoverM cfg) {
        if (cfg == null || TextUtils.isEmpty((CharSequence)cfg.policy)) {
            if (TextUtils.isNotEmpty((CharSequence)this._backup_server)) {
                this._enable_agent = false;
                this._nodes_count = 0;
                this._nodes.clear();
            }
            return;
        }
        if (cfg.url != null) {
            if (cfg.url.indexOf("://") > 0) {
                this._cfg = cfg;
                this._enable_agent = true;
            }
        } else {
            cfg.url = "";
        }
        this._cfg = cfg;
        ArrayList<String> _nodes2 = new ArrayList<String>();
        for (DiscoverTargetM m : this._cfg.list) {
            int sev_wgt = m.weight;
            String sev_url = m.protocol + "://" + m.address;
            if (this._cfg.url.contains("{server}")) {
                sev_url = this._cfg.url.replace("{server}", sev_url);
            }
            while (sev_wgt > 0) {
                _nodes2.add(sev_url);
                --sev_wgt;
            }
        }
        if (_nodes2.size() < this._nodes_count) {
            this._nodes_count = this._nodes.size();
            this._nodes = _nodes2;
        } else {
            this._nodes = _nodes2;
            this._nodes_count = this._nodes.size();
        }
    }

    public String getServer() {
        if (this._enable_agent) {
            return this._cfg.url;
        }
        if (this._nodes_count == 0) {
            return this._backup_server;
        }
        if (this._polling_val == 9999999) {
            this._polling_val = 0;
        }
        ++this._polling_val;
        int idx = this._polling_val % this._nodes_count;
        return this._nodes.get(idx);
    }

    public String name() {
        return this._service;
    }

    public String agent() {
        if (this._cfg == null || !this._enable_agent) {
            return null;
        }
        return this._cfg.url;
    }

    public String policy() {
        if (this._cfg == null) {
            return null;
        }
        return this._cfg.policy;
    }

    public List<String> nodes() {
        return Collections.unmodifiableList(this._nodes);
    }

    public void setBackup(String server) {
        this._backup_server = server;
    }

    public HttpUtils http(String path) {
        return HttpUtils.http((String)(this.getServer() + path)).headerAdd("Water-Trace-Id", WaterClient.waterTraceId()).headerAdd("Water-From", WaterClient.localServiceHost());
    }
}

