/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Random;
import org.noear.solon.Solon;
import org.noear.water.utils.LocalUtils;

public class SnowflakeUtils {
    private static final int TIME_LEN = 41;
    private static final int DATA_LEN = 5;
    private static final int WORK_LEN = 5;
    private static final int SEQ_LEN = 12;
    private static final long START_TIME = 1577808000000L;
    private static long LAST_TIME_STAMP = -1L;
    private static final int TIME_LEFT_BIT = 22;
    private static final long DATA_ID = SnowflakeUtils.getDataId();
    private static final long WORK_ID = SnowflakeUtils.getWorkId();
    private static final int DATA_MAX_NUM = 31;
    private static final int WORK_MAX_NUM = 31;
    private static final int DATA_RANDOM = 32;
    private static final int WORK_RANDOM = 32;
    private static final int DATA_LEFT_BIT = 17;
    private static final int WORK_LEFT_BIT = 12;
    private static long LAST_SEQ = 0L;
    private static final long SEQ_MAX_NUM = 4095L;

    public static synchronized long genId() {
        long now = System.currentTimeMillis();
        if (now < LAST_TIME_STAMP) {
            throw new RuntimeException(String.format("\u7cfb\u7edf\u65f6\u95f4\u9519\u8bef\uff01 %d \u6beb\u79d2\u5185\u62d2\u7edd\u751f\u6210\u96ea\u82b1ID\uff01", 1577808000000L - now));
        }
        if (now == LAST_TIME_STAMP) {
            if ((LAST_SEQ = LAST_SEQ + 1L & 0xFFFL) == 0L) {
                now = SnowflakeUtils.nextMillis(LAST_TIME_STAMP);
            }
        } else {
            LAST_SEQ = 0L;
        }
        LAST_TIME_STAMP = now;
        return now - 1577808000000L << 22 | DATA_ID << 17 | WORK_ID << 12 | LAST_SEQ;
    }

    public static long nextMillis(long lastMillis) {
        long now = System.currentTimeMillis();
        while (now <= lastMillis) {
            now = System.currentTimeMillis();
        }
        return now;
    }

    private static int getHostId(String s, int max) {
        byte[] bytes = s.getBytes();
        int sums = 0;
        for (byte b : bytes) {
            sums += b;
        }
        return sums % (max + 1);
    }

    protected static int getWorkId() {
        try {
            return SnowflakeUtils.getHostId(LocalUtils.getLocalAddr((int)Solon.cfg().serverPort()), 31);
        }
        catch (Exception e) {
            return new Random().nextInt(32);
        }
    }

    protected static int getDataId() {
        try {
            if (Solon.cfg().appName() != null) {
                return SnowflakeUtils.getHostId(Solon.cfg().appGroup() + "::" + Solon.cfg().appName(), 31);
            }
            return SnowflakeUtils.getHostId(Inet4Address.getLocalHost().getHostName(), 31);
        }
        catch (UnknownHostException e) {
            return new Random().nextInt(32);
        }
    }
}

