/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water;

import java.util.Map;
import org.noear.water.WaterClient;
import org.noear.water.WaterUpstream;
import org.noear.water.log.Level;
import org.noear.water.utils.HttpUtils;
import org.noear.weed.cache.CacheUsing;

public class WaterProxy {
    static final String SERVICE_WATER_PAAS = "waterpaas";
    static final String SERVICE_WATER_RAAS = "waterraas";

    public static String job(String service, String name) throws Exception {
        return WaterUpstream.get(service).http("/run/job/").data("name", name).post();
    }

    public static String call(String service, String path) throws Exception {
        return WaterProxy.call(service, path, null);
    }

    public static String call(String service, String path, Map<String, Object> args) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (args == null || args.size() == 0) {
            return WaterUpstream.get(service).http(path).get();
        }
        return WaterUpstream.get(service).http(path).data(args).post();
    }

    public static String callAndCache(String service, String path, Map<String, Object> args, CacheUsing cacheUsing) throws Exception {
        if (cacheUsing == null) {
            return WaterProxy.call(service, path, args);
        }
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(service).append("_");
        cacheKey.append(path).append("_");
        args.forEach((k, v) -> cacheKey.append((String)k).append("_").append(v.toString()).append("_"));
        return (String)cacheUsing.getEx(cacheKey.toString(), () -> WaterProxy.call(service, path, args));
    }

    public static String raas(String type, String tag, String name, Map<String, Object> args) throws Exception {
        String path = "/" + type + "/" + tag + "/" + name;
        return WaterProxy.raas(path, args);
    }

    public static String raas(String path, Map<String, Object> args) throws Exception {
        return WaterProxy.call(SERVICE_WATER_RAAS, path, args);
    }

    public static final String faas(String path) throws Exception {
        return WaterProxy.faas(path, null);
    }

    public static final String faas(String path, Map<String, Object> args) throws Exception {
        return WaterProxy.call(SERVICE_WATER_PAAS, path, args);
    }

    @Deprecated
    public static final String paas(String path, Map<String, Object> args) throws Exception {
        return WaterProxy.faas(path, args);
    }

    private static HttpUtils http(String url) {
        return HttpUtils.http((String)url).header("Water-Trace-Id", WaterClient.waterTraceId()).header("Water-From", WaterClient.localServiceHost());
    }

    public static void logTrace(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, Level.TRACE, map);
    }

    public static void logDebug(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, Level.DEBUG, map);
    }

    public static void logInfo(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, Level.INFO, map);
    }

    public static void logWarn(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, Level.WARN, map);
    }

    public static void logError(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, Level.ERROR, map);
    }
}

