/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.Date;
import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.water.dso.CallUtil;
import org.noear.water.model.MessageM;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.IDUtils;
import org.noear.water.utils.TextUtils;

public class MessageApi {
    public ONode subscribeTopic(String subscriber_key, String receiver_url, String access_key, String alarm_mobile, int receive_way, String ... topics) throws Exception {
        return this.subscribeTopic(subscriber_key, "", receiver_url, access_key, alarm_mobile, receive_way, topics);
    }

    public ONode subscribeTopic(String subscriber_key, String subscriber_note, String receiver_url, String access_key, String alarm_mobile, int receive_way, String ... topics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("note", subscriber_note);
        params.put("topic", String.join((CharSequence)",", topics));
        params.put("receiver_url", receiver_url);
        params.put("access_key", access_key);
        params.put("alarm_mobile", alarm_mobile);
        params.put("receive_way", receive_way + "");
        String txt = CallUtil.post("msg/subscribe/", params);
        return ONode.loadStr((String)txt);
    }

    public ONode unSubscribeTopic(String subscriber_key, String ... topics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("topic", String.join((CharSequence)",", topics));
        String txt = CallUtil.post("msg/unsubscribe/", params);
        return ONode.loadStr((String)txt);
    }

    public ONode sendMessage(String topic, String message) throws Exception {
        return this.sendMessage(IDUtils.guid(), topic, message, null);
    }

    public ONode sendMessage(String msg_key, String topic, String message) throws Exception {
        return this.sendMessage(msg_key, topic, message, null);
    }

    public ONode sendMessage(String msg_key, String topic, String message, Date planTime) throws Exception {
        String txt;
        ONode data;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        params.put("topic", topic);
        params.put("message", message);
        if (planTime != null) {
            String planTime2 = new Datetime(planTime).toString("yyyy-MM-dd HH:mm:ss");
            params.put("plan_time", planTime2);
        }
        if ((data = ONode.loadStr((String)(txt = CallUtil.post("msg/send/", params)))).get("code").getInt() == 1) {
            return data;
        }
        throw new Exception("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public ONode sendMessageCall(String message, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageCall(IDUtils.guid(), message, null, receiver_url, receiver_cehck);
    }

    public ONode sendMessageCall(String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck) throws Exception {
        String txt;
        ONode data;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        params.put("message", message);
        params.put("receiver_url", receiver_url);
        params.put("receiver_cehck", receiver_cehck);
        if (planTime != null) {
            String planTime2 = new Datetime(planTime).toString("yyyy-MM-dd HH:mm:ss");
            params.put("plan_time", planTime2);
        }
        if ((data = ONode.loadStr((String)(txt = CallUtil.post("msg/send/", params)))).get("code").getInt() == 1) {
            return data;
        }
        throw new Exception("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public ONode cancelMessage(String msg_key) throws Exception {
        return this.cancelMessage(msg_key, null);
    }

    public ONode cancelMessage(String msg_key, String subscriber_key) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        String txt = CallUtil.post("msg/cancel/", params);
        return ONode.loadStr((String)txt);
    }

    public ONode succeedMessage(String msg_key) throws Exception {
        return this.succeedMessage(msg_key, null);
    }

    public ONode succeedMessage(String msg_key, String subscriber_key) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        String txt = CallUtil.post("msg/succeed/", params);
        return ONode.loadStr((String)txt);
    }

    public boolean checkMessage(MessageM msg, String access_key) {
        if (msg.id < 1L) {
            return false;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append(msg.id).append("#");
        sb.append(msg.key).append("#");
        sb.append(msg.topic).append("#");
        sb.append(msg.message).append("#");
        sb.append(access_key);
        String sgin_slf = EncryptUtils.md5((String)sb.toString());
        return sgin_slf.equals(msg.sgin);
    }
}

