/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import org.noear.water.WaterConfig;
import org.noear.water.utils.RedisX;

public class LockUtils {
    private static RedisX _redis_uni = WaterConfig.redis_cfg().getRd(2);

    public static boolean tryLock(String group, String key, int inSeconds, String inMaster) {
        String key2 = group + ".lk." + key;
        return (Boolean)_redis_uni.open1(ru -> {
            if (!ru.key(key2).exists().booleanValue()) {
                ru.key(key2).expire(inSeconds).lock(inMaster);
            }
            return inMaster.equals(ru.key(key2).get());
        });
    }

    public static boolean tryLock(String group, String key, int inSeconds) {
        String key2 = group + ".lk." + key;
        return (Boolean)_redis_uni.open1(ru -> {
            if (!ru.key(key2).exists().booleanValue()) {
                return ru.key(key2).expire(inSeconds).lock("_");
            }
            return false;
        });
    }

    public static boolean isLocked(String group, String key) {
        String key2 = group + ".lk." + key;
        return (Boolean)_redis_uni.open1(ru -> ru.key(key2).exists());
    }

    public static void unLock(String group, String key) {
        String key2 = group + ".lk." + key;
        _redis_uni.open0(ru -> ru.key(key2).delete());
    }

    public static boolean isUnique(String group, String key) {
        return LockUtils.isUnique(group, key, 3);
    }

    public static boolean isUnique(String group, String key, int inSeconds) {
        String key2 = group + key;
        long val = (Long)_redis_uni.open1(ru -> {
            if (ru.key(key2).exists().booleanValue()) {
                return 2L;
            }
            return ru.key(key2).expire(inSeconds).incr(1L);
        });
        return val == 1L;
    }
}

