/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.util.UUID;
import org.noear.water.WaterConfig;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.RedisX;

public class IDUtils {
    private static RedisX _redis_idx = WaterConfig.redis_cfg().getRd(1);

    public static String guid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static long newID(String group, String key, int cacheTime) {
        return (Long)_redis_idx.open1(ru -> ru.key(group).expire(cacheTime).hashIncr(key, 1L));
    }

    public static long newID(String group, String key) {
        return IDUtils.newID(group, key, 315360000);
    }

    public static long newIDOfDate(String group, String key) {
        String group2 = group + "." + Datetime.Now().toString("yyyyMMdd");
        return IDUtils.newID(group2, key, 90000);
    }

    public static long newIDOfHour(String group, String key) {
        String group2 = group + "." + Datetime.Now().toString("yyyyMMddHH");
        return IDUtils.newID(group2, key, 7200);
    }
}

