/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.noear.water.WaterClient;
import org.noear.water.model.ConfigM;
import org.noear.water.utils.HttpUtils;
import org.noear.weed.cache.CacheUsing;

public class WaterProxy {
    private static String paas_uri;
    private static String raas_uri;
    private static Map<String, ConfigM> _sevs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryInit(String service) {
        Map<String, ConfigM> map = _sevs;
        synchronized (map) {
            if (!_sevs.containsKey(service)) {
                ConfigM cfg = WaterClient.Config.get("_service", service);
                _sevs.put(service, cfg);
            }
        }
    }

    private static String callDo(String url, String fun, Map<String, Object> args) throws Exception {
        String fun_url = url.replace("{fun}", fun);
        HashMap form = new HashMap();
        if (args != null) {
            args.forEach((k, v) -> {
                if (v != null) {
                    form.put(k, v.toString());
                }
            });
        }
        return HttpUtils.http((String)fun_url).data(form).post();
    }

    public static String call(String service, String fun, Map<String, Object> args) throws Exception {
        if (service.indexOf("://") > 0) {
            return WaterProxy.callDo(service, fun, args);
        }
        WaterProxy.tryInit(service);
        ConfigM cfg = _sevs.get(service);
        return WaterProxy.callDo(cfg.value, fun, args);
    }

    public static String callAndCache(String service, String fun, Map<String, Object> args, CacheUsing cacheUsing) throws Exception {
        if (cacheUsing == null) {
            return WaterProxy.call(service, fun, args);
        }
        StringBuilder wkey = new StringBuilder();
        wkey.append(service).append("_");
        wkey.append(fun).append("_");
        args.forEach((k, v) -> wkey.append((String)k).append("_").append(v.toString()).append("_"));
        return (String)cacheUsing.getEx(wkey.toString(), () -> WaterProxy.call(service, fun, args));
    }

    public static String raas(String type, String tag, String name, Map<String, Object> args) throws IOException {
        String path = "/" + type + "/" + tag + "/" + name;
        return WaterProxy.raas(path, args);
    }

    public static String raas(String path, Map<String, Object> args) throws IOException {
        if (raas_uri == null) {
            raas_uri = WaterClient.Config.get((String)"water", (String)"raas_uri").value;
        }
        return HttpUtils.http((String)(raas_uri + path)).data(args).post();
    }

    public static final String paas(String path, Map<String, Object> args) throws IOException {
        if (paas_uri == null) {
            paas_uri = WaterClient.Config.get((String)"water", (String)"paas_uri").value;
        }
        if (args == null) {
            return HttpUtils.http((String)(paas_uri + path)).get();
        }
        return HttpUtils.http((String)(paas_uri + path)).data(args).post();
    }

    static {
        _sevs = Collections.synchronizedMap(new HashMap());
    }
}

