/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.noear.snack.ONode;
import org.noear.water.dso.CallUtil;
import org.noear.water.model.ConfigM;
import org.noear.water.model.ConfigSetM;

public class ConfigApi {
    private Map<String, ConfigSetM> _cfgs = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInit(String tag) {
        Map<String, ConfigSetM> map = this._cfgs;
        synchronized (map) {
            if (this._cfgs.containsKey(tag)) {
                return;
            }
            this.load(tag);
        }
    }

    private void load(String tag) {
        ConfigSetM cfgSet;
        block2: {
            cfgSet = new ConfigSetM(tag);
            try {
                String temp = CallUtil.get("cfg/get/?v=2&tag=" + tag);
                cfgSet.load(ONode.loadStr((String)temp));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!this._cfgs.containsKey(tag)) break block2;
                return;
            }
        }
        this._cfgs.put(tag, cfgSet);
    }

    public void reload(String tag) {
        if (!this._cfgs.containsKey(tag)) {
            return;
        }
        this.load(tag);
    }

    public Properties getProperties(String tag) {
        this.tryInit(tag);
        return this._cfgs.get(tag).getPropSet();
    }

    public ConfigM getByTagKey(String tagKey) {
        String[] ss = tagKey.split("/");
        return this.get(ss[0], ss[1]);
    }

    public ConfigM get(String tag, String key) {
        this.tryInit(tag);
        return this._cfgs.get(tag).get(key);
    }

    public void set(String tag, String key, String value) throws IOException {
        CallUtil.http("cfg/set/").data("tag", tag).data("key", key).data("value", value).post();
    }
}

