/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.water.dso.CallUtil;
import org.noear.water.utils.TextUtils;
import org.noear.weed.Command;

public class TrackApi {
    public void track(String service, String tag, String name, long timespan) {
        this.track(service, tag, name, timespan, null, null);
    }

    public void track(String service, String tag, String name, long timespan, String _node) {
        this.track(service, tag, name, timespan, _node, null);
    }

    public void track(String service, String tag, String name, long timespan, String _node, String _from) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (_node != null) {
            params.put("_node", _node);
        }
        if (_from != null) {
            params.put("_from", _from);
        }
        params.put("service", service);
        params.put("tag", tag);
        params.put("name", name);
        params.put("timespan", timespan + "");
        CallUtil.postAsync("sev/track/api/", params);
    }

    public void track(String service, Command cmd, long thresholdValue) {
        long timespan = cmd.timespan();
        if (timespan > thresholdValue) {
            this.do_track(service, cmd, null, null, null, null, null);
        }
    }

    public void track(String service, Command cmd, String ua, String path, String operator, String operator_ip) {
        this.do_track(service, cmd, ua, path, operator, operator_ip, null);
    }

    private void do_track(String service, Command cmd, String ua, String path, String operator, String operator_ip, String note) {
        long interval = cmd.timespan();
        Map map = cmd.paramMap();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("schema", cmd.context.schema());
        params.put("interval", String.valueOf(interval));
        params.put("cmd_sql", cmd.text);
        params.put("cmd_arg", ONode.loadObj((Object)map).toJson());
        if (!TextUtils.isEmpty((CharSequence)operator)) {
            params.put("operator", operator);
        }
        if (!TextUtils.isEmpty((CharSequence)operator_ip)) {
            params.put("operator_ip", operator_ip);
        }
        if (!TextUtils.isEmpty((CharSequence)path)) {
            params.put("path", path);
        }
        if (!TextUtils.isEmpty((CharSequence)ua)) {
            params.put("ua", ua);
        }
        if (!TextUtils.isEmpty((CharSequence)note)) {
            params.put("note", note);
        }
        CallUtil.postAsync("sev/track/sql/", params);
    }
}

