/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.water.model.ConfigM;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.HttpUtils;
import org.noear.water.utils.TextUtils;

public class OSSUtils {
    private String bucket;
    private String endpoint;
    private String accessKeyId;
    private String accessSecretKey;
    private static Map<String, OSSUtils> cacheMap = new ConcurrentHashMap<String, OSSUtils>();

    public static OSSUtils get(ConfigM cfg) {
        OSSUtils tmp = cacheMap.get(cfg.value);
        if (tmp == null) {
            tmp = new OSSUtils(cfg.getProp());
            cacheMap.putIfAbsent(cfg.value, tmp);
        }
        return tmp;
    }

    public OSSUtils(Properties prop) {
        this(prop.getProperty("bucket"), prop.getProperty("endpoint"), prop.getProperty("accessKeyId"), prop.getProperty("accessSecretKey"));
    }

    public OSSUtils(String bucket, String endpoint, String accessKeyId, String accessSecretKey) {
        this.bucket = bucket;
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessSecretKey = accessSecretKey;
    }

    public void putFile(String objName, InputStream content, String contentType) throws Exception {
        HttpUtils client = this.buildRequest(objName, contentType, "PUT");
        client.bodyRaw(content, contentType).put();
    }

    public void putString(String objName, String content) throws Exception {
        HttpUtils client = this.buildRequest(objName, null, "PUT");
        client.bodyTxt(content, null).put();
    }

    public String getString(String objName) throws Exception {
        HttpUtils client = this.buildRequest(objName, null, "GET");
        return client.get();
    }

    private HttpUtils buildRequest(String objName, String contentType, String method) {
        String objPath = "/" + this.bucket + '/' + objName;
        String url = "http://" + this.bucket + "." + this.endpoint + '/';
        String date = Datetime.Now().toGmtString();
        String sign_data = this.signData(method, date, objPath, contentType);
        String sign = EncryptUtils.hmacSha1((String)sign_data, (String)this.accessSecretKey);
        String auth = "OSS " + this.accessKeyId + ":" + sign;
        HttpUtils http = HttpUtils.http((String)(url + objName));
        http.header("Date", date).header("Authorization", auth);
        return http;
    }

    private String signData(String method, String date, String objPath, String contentType) {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            return method + "\n\n\n" + date + "\n" + objPath;
        }
        return method + "\n\n" + contentType + "\n" + date + "\n" + objPath;
    }
}

