/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.ThreadFactory;
import org.noear.water.log.Level;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.WaterLogEvent;
import org.slf4j.impl.WaterLogEventHandler;
import org.slf4j.impl.WaterLogThreadFactory;
import org.slf4j.impl.WaterLogger;

public enum WaterLoggerFactory implements ILoggerFactory
{
    INSTANCE;

    private final Disruptor<WaterLogEvent> disruptor;
    private volatile Level level = Level.INFO;

    private WaterLoggerFactory() {
        try {
            this.disruptor = new Disruptor(WaterLogEvent::new, 1024, (ThreadFactory)new WaterLogThreadFactory());
            this.disruptor.handleEventsWith(new EventHandler[]{new WaterLogEventHandler()});
            this.disruptor.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Logger getLogger(String name) {
        return new WaterLogger(name, this.disruptor);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }
}

