/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack.ONode;
import org.noear.water.WaterClient;
import org.noear.water.dso.CallUtil;
import org.noear.water.log.Level;
import org.noear.water.log.WaterLogger;
import org.noear.water.utils.TextUtils;
import org.noear.water.utils.ThrowableUtils;

public class LogApi {
    private Map<String, WaterLogger> loggerMap = new ConcurrentHashMap<String, WaterLogger>();

    public WaterLogger logger(String logger) {
        WaterLogger l;
        WaterLogger tmp = this.loggerMap.get(logger);
        if (tmp == null && (l = this.loggerMap.putIfAbsent(logger, tmp = new WaterLogger(logger))) != null) {
            tmp = l;
        }
        return tmp;
    }

    public void append(String logger, Level level, Map<String, Object> map) {
        this.append(logger, level, (String)map.get("tag"), (String)map.get("tag1"), (String)map.get("tag2"), (String)map.get("tag3"), (String)map.get("summary"), map.get("content"));
    }

    public void append(String logger, Level level, String summary, Object content) {
        this.append(logger, level, null, null, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String summary, Object content) {
        this.append(logger, level, tag, null, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String summary, Object content) {
        this.append(logger, level, tag, tag1, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String summary, Object content) {
        this.append(logger, level, tag, tag1, tag2, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.append(logger, level, tag, tag1, tag2, tag3, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content, boolean async) {
        if (TextUtils.isEmpty((CharSequence)logger)) {
            return;
        }
        if (logger.indexOf(".") > 0) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logger", logger);
        params.put("level", String.valueOf(level.code));
        if (tag != null) {
            params.put("tag", tag);
        }
        if (tag1 != null) {
            params.put("tag1", tag1);
        }
        if (tag2 != null) {
            params.put("tag2", tag2);
        }
        if (tag3 != null) {
            params.put("tag3", tag3);
        }
        if (summary != null) {
            params.put("summary", summary);
        }
        if (WaterClient.serviceAddr() != null) {
            params.put("from", WaterClient.serviceAddr());
        }
        if (content != null) {
            String tmp;
            if (content instanceof Throwable) {
                tmp = ThrowableUtils.getString((Throwable)((Throwable)content));
                params.put("content", tmp);
            } else if (content instanceof String) {
                params.put("content", (String)content);
            } else {
                tmp = ONode.load((Object)content).toJson();
                params.put("content", tmp);
            }
        }
        try {
            if (async) {
                CallUtil.postAsync("log/add/", params);
            } else {
                CallUtil.post("log/add/", params);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

