/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.model;

import com.zaxxer.hikari.HikariDataSource;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.noear.snack.ONode;
import org.noear.water.model.PropertiesM;
import org.noear.water.utils.RedisX;
import org.noear.water.utils.RunUtils;
import org.noear.water.utils.TextUtils;
import org.noear.weed.DbContext;
import org.noear.weed.cache.ICacheServiceEx;
import org.noear.weed.cache.LocalCache;
import org.noear.weed.cache.memcached.MemCache;

public final class ConfigM {
    public final String key;
    public final long lastModified;
    public final String value;
    private PropertiesM _prop;
    private ONode _node;
    private static Map<String, DbContext> _dbMap = new ConcurrentHashMap<String, DbContext>();

    public ConfigM() {
        this.key = null;
        this.lastModified = 0L;
        this.value = null;
    }

    public ConfigM(String key, String value, long lastModified) {
        this.key = key;
        this.value = value;
        this.lastModified = lastModified;
    }

    public String getString() {
        return this.value;
    }

    public String getString(String def) {
        return this.value == null ? def : this.value;
    }

    public int getInt(int def) {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return def;
        }
        return Integer.parseInt(this.value);
    }

    public long getLong(long def) {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return def;
        }
        return Long.parseLong(this.value);
    }

    public PropertiesM getProp() {
        if (this._prop == null) {
            this._prop = ConfigM.getProp(this.value);
        }
        return this._prop;
    }

    public static PropertiesM getProp(String text) {
        PropertiesM properties = new PropertiesM();
        RunUtils.runActEx(() -> properties.load(new StringReader(text)));
        return properties;
    }

    public ONode getNode() {
        if (this._node == null) {
            this._node = ONode.load((Object)this.value);
        }
        return this._node;
    }

    public <T> T getObject(Class<T> clz) {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return null;
        }
        if (this.value.trim().startsWith("{")) {
            return (T)this.getNode().toObject(clz);
        }
        return this.getProp().toObject(clz);
    }

    public RedisX getRd() {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return null;
        }
        return new RedisX((Properties)this.getProp());
    }

    public RedisX getRd(int db) {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return null;
        }
        return new RedisX((Properties)this.getProp(), db);
    }

    public RedisX getRd(int db, int maxTotaol) {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return null;
        }
        return new RedisX((Properties)this.getProp(), db, maxTotaol);
    }

    public ICacheServiceEx getCh(String keyHeader, int defSeconds) {
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return new LocalCache(keyHeader, defSeconds);
        }
        return new MemCache((Properties)this.getProp(), keyHeader, defSeconds);
    }

    public ICacheServiceEx getCh() {
        String name = System.getProperty("water.service.name");
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new RuntimeException("System.getProperty(\"water.service.name\") is null, please configure!");
        }
        return this.getCh(name, 300);
    }

    public DbContext getDb() {
        return this.getDb(false);
    }

    public DbContext getDb(boolean pool) {
        DbContext l;
        if (TextUtils.isEmpty((CharSequence)this.value)) {
            return null;
        }
        DbContext db = _dbMap.get(this.value);
        if (db == null && (l = _dbMap.putIfAbsent(this.value, db = this.getDbDo(pool))) != null) {
            db = l;
        }
        return db;
    }

    private DbContext getDbDo(boolean pool) {
        PropertiesM prop = this.getProp();
        String url = prop.getProperty("url");
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        DbContext db = new DbContext();
        if (pool) {
            HikariDataSource source = new HikariDataSource();
            source.setDataSourceProperties((Properties)prop);
            String schema = prop.getProperty("schema");
            String username = prop.getProperty("username");
            String password = prop.getProperty("password");
            String driverClassName = prop.getProperty("driverClassName");
            String connectionTimeout = prop.getProperty("connectionTimeout");
            String idleTimeout = prop.getProperty("idleTimeout");
            String maxLifetime = prop.getProperty("maxLifetime");
            String maximumPoolSize = prop.getProperty("maximumPoolSize");
            if (!TextUtils.isEmpty((CharSequence)url)) {
                source.setJdbcUrl(url);
            }
            if (!TextUtils.isEmpty((CharSequence)username)) {
                source.setUsername(username);
            }
            if (!TextUtils.isEmpty((CharSequence)password)) {
                source.setPassword(password);
            }
            if (!TextUtils.isEmpty((CharSequence)schema)) {
                source.setSchema(schema);
            }
            if (!TextUtils.isEmpty((CharSequence)driverClassName)) {
                source.setDriverClassName(driverClassName);
            }
            if (!TextUtils.isEmpty((CharSequence)connectionTimeout)) {
                source.setConnectionTimeout(Long.parseLong(connectionTimeout));
            }
            if (!TextUtils.isEmpty((CharSequence)idleTimeout)) {
                source.setIdleTimeout(Long.parseLong(idleTimeout));
            }
            if (!TextUtils.isEmpty((CharSequence)maxLifetime)) {
                source.setMaxLifetime(Long.parseLong(maxLifetime));
            }
            if (!TextUtils.isEmpty((CharSequence)maximumPoolSize)) {
                source.setMaximumPoolSize(Integer.parseInt(maximumPoolSize));
            }
            db.dataSourceSet((DataSource)source);
            db.schemaSet(schema);
        } else {
            db.propSet((Properties)this.getProp());
        }
        return db;
    }
}

