/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.log;

import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;
import org.noear.water.dso.LogPipeline;
import org.noear.water.log.Level;
import org.noear.water.log.LogEvent;
import org.noear.water.log.Logger;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.TextUtils;

public class WaterLogger
implements Logger {
    private static volatile Level level = Level.TRACE;
    private static volatile boolean gzip = false;
    private String _name;
    private String _tag;

    public static WaterLogger get(String name) {
        return new WaterLogger(name);
    }

    public static WaterLogger get(String name, Class<?> clz) {
        return new WaterLogger(name, clz);
    }

    public static void setLevel(Level level) {
        WaterLogger.level = level;
    }

    public static void setGzip(boolean gzip) {
        WaterLogger.gzip = gzip;
    }

    public static boolean isGzip() {
        return gzip;
    }

    public static void setInterval(long interval) {
        LogPipeline.singleton().setInterval(interval);
    }

    public static void setPacketSize(int packetSize) {
        LogPipeline.singleton().setPacketSize(packetSize);
    }

    public WaterLogger(String name) {
        this._name = name;
    }

    public WaterLogger(String name, String tag) {
        this(name);
        this._tag = tag;
    }

    public WaterLogger() {
        this(WaterSetting.water_logger_def());
    }

    public WaterLogger(Class<?> clz) {
        this(WaterSetting.water_logger_def());
        this._tag = clz.getSimpleName();
    }

    public WaterLogger(String name, Class<?> clz) {
        this(name);
        this._tag = clz.getSimpleName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isTraceEnabled() {
        return WaterLogger.level.code <= Level.TRACE.code;
    }

    public void trace(Object content) {
        this.trace(this._tag, null, null, null, null, content);
    }

    public void trace(String summary, Object content) {
        this.trace(this._tag, null, null, null, summary, content);
    }

    public void trace(String tag, String summary, Object content) {
        this.trace(tag, null, null, null, summary, content);
    }

    public void trace(String tag, String tag1, String summary, Object content) {
        this.trace(tag, tag1, null, null, summary, content);
    }

    public void trace(String tag, String tag1, String tag2, String summary, Object content) {
        this.trace(tag, tag1, tag2, null, summary, content);
    }

    public void trace(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.traceDo(tag, tag1, tag2, tag3, summary, content);
    }

    private void traceDo(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (this.isTraceEnabled()) {
            this.appendDo(Level.TRACE, tag, tag1, tag2, tag3, summary, content);
        }
    }

    public boolean isDebugEnabled() {
        return WaterLogger.level.code <= Level.DEBUG.code;
    }

    public void debug(Object content) {
        this.debug(this._tag, null, null, null, null, content);
    }

    public void debug(String summary, Object content) {
        this.debug(this._tag, null, null, null, summary, content);
    }

    public void debug(String tag, String summary, Object content) {
        this.debug(tag, null, null, null, summary, content);
    }

    public void debug(String tag, String tag1, String summary, Object content) {
        this.debug(tag, tag1, null, null, summary, content);
    }

    public void debug(String tag, String tag1, String tag2, String summary, Object content) {
        this.debug(tag, tag1, tag2, null, summary, content);
    }

    public void debug(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.debugDo(tag, tag1, tag2, tag3, summary, content);
    }

    private void debugDo(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (this.isDebugEnabled()) {
            this.appendDo(Level.DEBUG, tag, tag1, tag2, tag3, summary, content);
        }
    }

    public boolean isInfoEnabled() {
        return WaterLogger.level.code <= Level.INFO.code;
    }

    public void info(Object content) {
        this.info(this._tag, null, null, null, null, content);
    }

    public void info(String summary, Object content) {
        this.info(this._tag, null, null, null, summary, content);
    }

    public void info(String tag, String summary, Object content) {
        this.info(tag, null, null, null, summary, content);
    }

    public void info(String tag, String tag1, String summary, Object content) {
        this.info(tag, tag1, null, null, summary, content);
    }

    public void info(String tag, String tag1, String tag2, String summary, Object content) {
        this.info(tag, tag1, tag2, null, summary, content);
    }

    public void info(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.infoDo(tag, tag1, tag2, tag3, summary, content);
    }

    private void infoDo(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (this.isInfoEnabled()) {
            this.appendDo(Level.INFO, tag, tag1, tag2, tag3, summary, content);
        }
    }

    public boolean isWarnEnabled() {
        return WaterLogger.level.code <= Level.WARN.code;
    }

    public void warn(Object content) {
        this.warn(this._tag, null, null, null, null, content);
    }

    public void warn(String summary, Object content) {
        this.warn(this._tag, null, null, null, summary, content);
    }

    public void warn(String tag, String summary, Object content) {
        this.warn(tag, null, null, null, summary, content);
    }

    public void warn(String tag, String tag1, String summary, Object content) {
        this.warn(tag, tag1, null, null, summary, content);
    }

    public void warn(String tag, String tag1, String tag2, String summary, Object content) {
        this.warn(tag, tag1, tag2, null, summary, content);
    }

    public void warn(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.warnDo(tag, tag1, tag2, tag3, summary, content);
    }

    private void warnDo(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (this.isWarnEnabled()) {
            this.appendDo(Level.WARN, tag, tag1, tag2, tag3, summary, content);
        }
    }

    public boolean isErrorEnabled() {
        return WaterLogger.level.code <= Level.ERROR.code;
    }

    public void error(Object content) {
        this.error(this._tag, null, null, null, null, content);
    }

    public void error(String summary, Object content) {
        this.error(this._tag, null, null, null, summary, content);
    }

    public void error(String tag, String summary, Object content) {
        this.error(tag, null, null, null, summary, content);
    }

    public void error(String tag, String tag1, String summary, Object content) {
        this.error(tag, tag1, null, null, summary, content);
    }

    public void error(String tag, String tag1, String tag2, String summary, Object content) {
        this.error(tag, tag1, tag2, null, summary, content);
    }

    public void error(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.errorDo(tag, tag1, tag2, tag3, summary, content);
    }

    private void errorDo(String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (this.isErrorEnabled()) {
            this.appendDo(Level.ERROR, tag, tag1, tag2, tag3, summary, content);
        }
    }

    private void appendDo(Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (TextUtils.isEmpty((CharSequence)this.getName())) {
            return;
        }
        Datetime datetime = Datetime.Now();
        LogEvent log = new LogEvent();
        log.logger = this.getName();
        log.trace_id = WaterClient.waterTraceId();
        log.level = level.code;
        log.tag = tag;
        log.tag1 = tag1;
        log.tag2 = tag2;
        log.tag3 = tag3;
        log.summary = summary;
        log.content = content;
        log.from = WaterClient.localServiceHost();
        log.log_date = datetime.getDate();
        log.log_fulltime = datetime.getFulltime();
        LogPipeline.singleton().add(log);
    }

    public void append(Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.appendDo(level, tag, tag1, tag2, tag3, summary, content);
    }

    public void slf4jWrite(Level level, String tag, String content) {
        this.appendDo(level, "slf4j", tag, null, null, null, content);
    }
}

