/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.io.IOException;
import java.util.HashMap;
import org.noear.water.WaterAddress;
import org.noear.water.WaterSetting;
import org.noear.water.dso.CallUtils;

public class WhitelistApi {
    protected final CallUtils callUtils = new CallUtils(WaterAddress.getWhitelistApiUrl());
    public static final String tag_master = "master";
    public static final String tag_client = "client";
    public static final String tag_server = "server";
    public static final String tag_clientAndServer = "client,server";

    private String checkDo0(String tags, String type, String value) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tags", tags);
        params.put("type", type);
        params.put("value", value);
        return this.callUtils.post("/run/whitelist/check/", params);
    }

    private boolean checkDo(String tags, String type, String value) {
        String cache_key = new StringBuilder(100).append(tags).append("_").append(type).append("_").append(value).toString();
        try {
            String val = (String)WaterSetting.cacheLocal.getBy(10, cache_key, us -> this.checkDo0(tags, type, value));
            return "OK".equals(val);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean exists(String tags, String type, String value) {
        return this.checkDo(tags, type, value);
    }

    public boolean existsOfIp(String tags, String value) {
        return this.checkDo(tags, "ip", value);
    }

    public boolean existsOfClientIp(String value) {
        return this.checkDo(tag_client, "ip", value);
    }

    public boolean existsOfClientAndServerIp(String value) {
        return this.checkDo(tag_clientAndServer, "ip", value);
    }

    public boolean existsOfServerIp(String value) {
        return this.checkDo(tag_server, "ip", value);
    }

    public boolean existsOfMasterIp(String value) {
        return this.checkDo(tag_master, "ip", value);
    }

    public boolean existsOfDomain(String tags, String value) {
        return this.checkDo(tags, "domain", value);
    }

    public boolean existsOfMobile(String tags, String value) {
        return this.checkDo(tags, "domain", value);
    }
}

