/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.dso.ApiCaller;
import org.noear.water.dso.DiscoverHandler;
import org.noear.water.model.DiscoverM;

public class RegistryApi {
    protected final ApiCaller apiCaller;
    private Map<String, Set<DiscoverHandler>> _event = new HashMap<String, Set<DiscoverHandler>>();

    public RegistryApi() {
        this.apiCaller = new ApiCaller(WaterAddress.getRegistryApiUrl());
    }

    public void register(String service, String address, String meta, boolean is_unstable) {
        this.register(service, address, meta, "", 1, "", is_unstable);
    }

    public void register(String service, String address, String check_url, String alarm_mobile, boolean is_unstable) {
        this.register(service, address, check_url, 0, alarm_mobile, is_unstable);
    }

    public void register(String service, String address, String check_url, int check_type, String alarm_mobile, boolean is_unstable) {
        this.register(service, address, "", check_url, check_type, alarm_mobile, is_unstable);
    }

    public void register(String service, String address, String meta, String check_url, int check_type, String alarm_mobile, boolean is_unstable) {
        String code_location = WaterClient.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        this.register(service, address, meta, check_url, check_type, alarm_mobile, code_location, is_unstable);
    }

    public void register(String service, String address, String meta, String check_url, int check_type, String alarm_mobile, String code_location, boolean is_unstable) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("address", address);
        params.put("meta", meta);
        params.put("alarm_mobile", alarm_mobile);
        params.put("is_unstable", is_unstable ? "1" : "0");
        params.put("code_location", code_location);
        params.put("check_url", check_url);
        params.put("check_type", check_type + "");
        try {
            this.apiCaller.post("/sev/reg/", params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void unregister(String service, String address, String meta) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("address", address);
        params.put("meta", meta);
        try {
            this.apiCaller.post("/sev/unreg/", params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void set(String service, String address, String meta, boolean enabled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("address", address);
        params.put("meta", meta);
        params.put("enabled", enabled ? "1" : "0");
        try {
            this.apiCaller.post("/sev/set/", params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public DiscoverM discover(String service, String consumer, String consumer_address) {
        return this.load0(service, consumer, consumer_address);
    }

    public void discoverFlush(String service, String consumer, String consumer_address) {
        DiscoverM d1 = this.load0(service, consumer, consumer_address);
        this.noticeTry(service, d1);
    }

    private DiscoverM load0(String service, String consumer, String consumer_address) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("consumer", consumer);
        params.put("consumer_address", consumer_address);
        try {
            String json = this.apiCaller.post("/sev/discover/", params);
            ONode rst = ONode.loadStr((String)json);
            if (rst.get("code").getInt() != 1) {
                return null;
            }
            ONode data = rst.get("data");
            if (data.isObject()) {
                DiscoverM cfg = new DiscoverM();
                cfg.url = data.get("url").getString();
                cfg.policy = data.get("policy").getString();
                if (data.contains("list")) {
                    for (ONode n : data.get("list").ary()) {
                        cfg.add(n.get("protocol").getString(), n.get("address").getString(), n.get("meta").getString(), n.get("weight").getInt());
                    }
                }
                return cfg;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void noticeTry(String service, DiscoverM discover) {
        Set<DiscoverHandler> tmp = this._event.get(service);
        if (tmp != null) {
            for (DiscoverHandler r : tmp) {
                r.handler(discover);
            }
        }
    }

    public void subscribe(String service, DiscoverHandler callback) {
        Set<DiscoverHandler> tmp = this._event.get(service);
        if (tmp == null) {
            tmp = new HashSet<DiscoverHandler>();
            this._event.put(service, tmp);
        }
        tmp.add(callback);
    }
}

