/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water;

import org.noear.water.WaterClient;
import org.noear.water.model.MessageM;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.LocalUtils;
import org.noear.water.utils.TextUtils;
import org.noear.water.utils.ext.Fun1;

public abstract class WaterAdapter {
    protected String service_check_path = null;
    protected String service_stop_path = null;
    protected String msg_receiver_path = null;
    protected int service_port = 0;

    public abstract String alarm_mobile();

    public abstract String service_name();

    public String service_secretKey() {
        return null;
    }

    public boolean is_unstable() {
        return false;
    }

    public String localHost() {
        return null;
    }

    private String msg_receiver_url_local() {
        String temp = "http://" + WaterAdapter.getLocalAddress(this.service_port) + this.msg_receiver_path;
        temp = temp.replace("//", "/").replace(":/", "://");
        return temp;
    }

    protected void registerService() {
        if (this.service_port > 0 && !TextUtils.isEmpty((CharSequence)this.service_check_path)) {
            String local_host = WaterAdapter.getLocalAddress(this.service_port);
            WaterClient.Registry.add(this.service_name(), local_host, this.service_check_path, this.alarm_mobile(), this.is_unstable());
        }
    }

    protected void messageSubscribe() {
        if (!TextUtils.isEmpty((CharSequence)this.msg_receiver_path)) {
            try {
                this.messageSubscribeTopicLocal(0, "water.cache.update", "water.config.update");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.messageSubscribeHandler();
    }

    public void messageSubscribeHandler() {
    }

    private void messageSubscribeTopicLocal(int receive_way, String ... topics) throws Exception {
        if (TextUtils.isEmpty((CharSequence)this.service_secretKey())) {
            return;
        }
        String msg_receiver_url_local = this.msg_receiver_url_local();
        String msg_subscriber_id_local = EncryptUtils.md5((String)(this.service_name() + msg_receiver_url_local));
        WaterClient.Message.subscribeTopic(msg_subscriber_id_local, this.service_name(), msg_receiver_url_local, this.service_secretKey(), this.alarm_mobile(), receive_way, topics);
    }

    public void messageSubscribeTopic(String msg_receiver_url, int receive_way, String ... topics) throws Exception {
        if (TextUtils.isEmpty((CharSequence)msg_receiver_url)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.service_name())) {
            return;
        }
        WaterClient.Message.subscribeTopic(this.service_name(), msg_receiver_url, this.service_secretKey(), this.alarm_mobile(), receive_way, topics);
    }

    public void configUpdateHandler(String tag, String name) {
    }

    public void cacheUpdateHandler(String tag) {
    }

    protected String doMessageReceive(Fun1<String, String> paramters) throws Exception {
        MessageM msg = new MessageM(paramters);
        if (!WaterClient.Message.checkMessage(msg, this.service_secretKey())) {
            return "CHECK ERROR";
        }
        boolean isOk = this.messageReceiveForInner(msg);
        isOk = this.messageReceiveHandler(msg) || isOk;
        return isOk ? "OK" : "ERROR";
    }

    public boolean messageReceiveHandler(MessageM msg) throws Exception {
        return true;
    }

    protected boolean messageReceiveForInner(MessageM msg) {
        if (!"water.cache.update".equals(msg.topic) && !"water.config.update".equals(msg.topic)) {
            return false;
        }
        try {
            String[] tag_keys = msg.message.split(";");
            if ("water.cache.update".equals(msg.topic)) {
                for (String tag : tag_keys) {
                    if (TextUtils.isEmpty((CharSequence)tag)) continue;
                    this.cacheUpdateHandler(tag);
                }
            }
            if ("water.config.update".equals(msg.topic)) {
                for (String tagKey : tag_keys) {
                    String[] ss = tagKey.split("::");
                    if (ss.length <= 1) continue;
                    WaterClient.Config.reload(ss[0]);
                    this.configUpdateHandler(ss[0], ss[1]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected static String getLocalAddress(int port) {
        String host = null;
        try {
            host = LocalUtils.getLocalIp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (port > 0) {
            return host + ":" + port;
        }
        return host;
    }
}

