/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.water.WaterClient;
import org.noear.water.dso.WaterUpstream;
import org.noear.water.dso.WaterUpstreamImp;
import org.noear.water.model.ConfigM;
import org.noear.water.utils.RedisX;
import org.noear.water.utils.TextUtils;
import org.noear.weed.DbContext;
import org.noear.weed.cache.ICacheServiceEx;
import org.noear.weed.cache.LocalCache;

public class WaterConfig {
    public static Map<String, DbContext> libOfDb = new ConcurrentHashMap<String, DbContext>();
    public static Map<String, RedisX> libOfRd = new ConcurrentHashMap<String, RedisX>();
    public static Map<String, ICacheServiceEx> libOfCache = new ConcurrentHashMap<String, ICacheServiceEx>();
    private static String _water_api_url = null;
    private static WaterUpstream _water_cfg_upstream = new WaterUpstreamImp();
    private static WaterUpstream _water_sev_upstream = new WaterUpstreamImp();
    public static final ExecutorService pools;
    public static final ICacheServiceEx cacheLocal;
    private static final String lock = "";
    private static ConfigM _redis_cfg;
    private static ConfigM _redis_track_cfg;
    private static ConfigM _cache_cfg;

    public static String water_api_url() {
        return _water_api_url;
    }

    public static WaterUpstream water_cfg_upstream() {
        return _water_cfg_upstream;
    }

    public static WaterUpstream water_sev_upstream() {
        return _water_sev_upstream;
    }

    public static void water_sev_upstream(WaterUpstream upstream) {
        upstream.setAgentDef(WaterConfig.water_api_url());
        _water_sev_upstream = upstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigM redis_cfg() {
        if (_redis_cfg != null) return _redis_cfg;
        String string = lock;
        synchronized (lock) {
            if (_redis_cfg != null) return _redis_cfg;
            _redis_cfg = WaterConfig.cfg("water_redis");
            // ** MonitorExit[var0] (shouldn't be in output)
            return _redis_cfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigM redis_track_cfg() {
        if (_redis_track_cfg != null) return _redis_track_cfg;
        String string = lock;
        synchronized (lock) {
            if (_redis_track_cfg == null) {
                _redis_track_cfg = WaterConfig.cfg("water_redis_track");
            }
            if (_redis_track_cfg != null && !TextUtils.isEmpty((CharSequence)WaterConfig._redis_track_cfg.value)) return _redis_track_cfg;
            _redis_track_cfg = WaterConfig.cfg("water_redis");
            // ** MonitorExit[var0] (shouldn't be in output)
            return _redis_track_cfg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigM cache_cfg() {
        if (_cache_cfg != null) return _cache_cfg;
        String string = lock;
        synchronized (lock) {
            if (_cache_cfg != null) return _cache_cfg;
            _cache_cfg = WaterConfig.cfg("water_cache");
            // ** MonitorExit[var0] (shouldn't be in output)
            return _cache_cfg;
        }
    }

    public static void reload() {
        _redis_cfg = WaterConfig.cfg("water_redis");
        _cache_cfg = WaterConfig.cfg("water_cache");
    }

    private static ConfigM cfg(String key) {
        return WaterClient.Config.get("water", key);
    }

    static {
        String host = System.getProperty("water.host");
        if (!TextUtils.isEmpty((CharSequence)host)) {
            if (host.indexOf("://") < 0) {
                host = "http://" + host;
            }
            _water_api_url = host.endsWith("/") ? host.substring(0, host.length() - 2) : host;
        }
        if (TextUtils.isEmpty((CharSequence)_water_api_url)) {
            throw new RuntimeException("System.getProperty(\"water.host\") is null, please configure!");
        }
        pools = Executors.newCachedThreadPool();
        cacheLocal = new LocalCache();
    }
}

