/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.Date;
import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.dso.ApiCaller;
import org.noear.water.dso.MessageHandler;
import org.noear.water.model.MessageM;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.IDUtils;
import org.noear.water.utils.TextUtils;
import org.noear.water.utils.ext.Fun1;

public class MessageApi {
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getMessageApiUrl());

    public boolean subscribeTopic(String subscriber_key, String receive_url, String receive_key, String alarm_mobile, int receive_way, boolean is_unstable, String ... topics) throws Exception {
        return this.subscribeTopic(subscriber_key, "", receive_url, receive_key, alarm_mobile, receive_way, is_unstable, topics);
    }

    public boolean subscribeTopic(String subscriber_key, String subscriber_note, String receive_url, String receive_key, String alarm_mobile, int receive_way, boolean is_unstable, String ... topics) throws Exception {
        String topics_str = String.join((CharSequence)",", topics);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("note", subscriber_note);
        params.put("topic", topics_str);
        params.put("receiver_url", receive_url);
        params.put("receive_url", receive_url);
        params.put("receive_way", receive_way + "");
        params.put("receive_key", receive_key);
        params.put("access_key", receive_key);
        params.put("alarm_mobile", alarm_mobile);
        params.put("is_unstable", is_unstable ? "1" : "0");
        String txt = this.apiCaller.post("/msg/subscribe/", params);
        System.out.println("MessageApi::/msg/subscribe/:" + topics_str + "(" + receive_url + "}:" + txt);
        int code = ONode.loadStr((String)txt).get("code").getInt();
        return code == 1 || code == 200;
    }

    public boolean unSubscribeTopic(String subscriber_key, String ... topics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("subscriber_key", subscriber_key);
        params.put("topic", String.join((CharSequence)",", topics));
        String txt = this.apiCaller.post("/msg/unsubscribe/", params);
        System.out.println("MessageApi::/msg/unsubscribe/:" + txt);
        int code = ONode.loadStr((String)txt).get("code").getInt();
        return code == 1 || code == 200;
    }

    public boolean sendMessage(String topic, String message) throws Exception {
        return this.sendMessage(null, topic, message, null);
    }

    public boolean sendMessage(String msg_key, String topic, String message) throws Exception {
        return this.sendMessage(msg_key, topic, message, null);
    }

    public boolean sendMessage(String msg_key, String topic, String message, Date planTime) throws Exception {
        return this.sendMessageAndTags(msg_key, topic, message, planTime, null);
    }

    public boolean sendMessageAndTags(String topic, String message, String tags) throws Exception {
        return this.sendMessageAndTags(null, topic, message, tags);
    }

    public boolean sendMessageAndTags(String msg_key, String topic, String message, String tags) throws Exception {
        return this.sendMessageAndTags(msg_key, topic, message, null, tags);
    }

    public boolean sendMessageAndTags(String msg_key, String topic, String message, Date planTime, String tags) throws Exception {
        String txt;
        ONode data;
        int code;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("topic", topic);
        params.put("message", message);
        if (msg_key != null) {
            params.put("key", msg_key);
        }
        if (tags != null) {
            params.put("tags", tags);
        }
        if (planTime != null) {
            params.put("plan_time", String.valueOf(planTime.getTime()));
        }
        if ((code = (data = ONode.loadStr((String)(txt = this.apiCaller.post("/msg/send/", params)))).get("code").getInt()) == 1 || code == 200) {
            return true;
        }
        throw new RuntimeException("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public boolean sendMessageCallback(String message, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageCallback(null, message, null, receiver_url, receiver_cehck);
    }

    public boolean sendMessageCallback(String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageAndTagsCallback(msg_key, message, planTime, receiver_url, receiver_cehck, null);
    }

    public boolean sendMessageAndTagsCallback(String message, String receiver_url, String receiver_cehck, String tags) throws Exception {
        return this.sendMessageAndTagsCallback(null, message, null, receiver_url, receiver_cehck, tags);
    }

    public boolean sendMessageAndTagsCallback(String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck, String tags) throws Exception {
        if (TextUtils.isEmpty((CharSequence)msg_key)) {
            msg_key = IDUtils.guid();
        }
        if (tags == null) {
            tags = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        params.put("tags", tags);
        params.put("message", message);
        params.put("receiver_url", receiver_url);
        params.put("receiver_cehck", receiver_cehck);
        if (planTime != null) {
            params.put("plan_time", String.valueOf(planTime.getTime()));
        }
        String txt = this.apiCaller.post("/msg/send/", params);
        System.out.println("MessageApi::/msg/send/:" + txt);
        ONode data = ONode.loadStr((String)txt);
        int code = data.get("code").getInt();
        if (code == 1 || code == 200) {
            return true;
        }
        throw new RuntimeException("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public boolean cancelMessage(String msg_key) throws Exception {
        return this.cancelMessage(msg_key, null);
    }

    public boolean cancelMessage(String msg_key, String subscriber_key) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        String txt = this.apiCaller.post("/msg/cancel/", params);
        System.out.println("MessageApi::/msg/cancel/:" + txt);
        int code = ONode.loadStr((String)txt).get("code").getInt();
        return code == 1 || code == 200;
    }

    public boolean succeedMessage(String msg_key) throws Exception {
        return this.succeedMessage(msg_key, null);
    }

    public boolean succeedMessage(String msg_key, String subscriber_key) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        String txt = this.apiCaller.post("/msg/succeed/", params);
        System.out.println("MessageApi::/msg/succeed/:" + txt);
        int code = ONode.loadStr((String)txt).get("code").getInt();
        return code == 1 || code == 200;
    }

    public boolean checkMessage(MessageM msg, String receive_key) {
        if (TextUtils.isEmpty((CharSequence)msg.topic)) {
            return false;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append(msg.key).append("#");
        sb.append(msg.topic).append("#");
        sb.append(msg.message).append("#");
        sb.append(receive_key);
        String sgin_slf = EncryptUtils.md5((String)sb.toString());
        return sgin_slf.equals(msg.sgin);
    }

    public String receiveMessage(Fun1<String, String> paramS, String service_secretKey, MessageHandler consumer) throws Throwable {
        MessageM msg = new MessageM(paramS);
        if (!WaterClient.Message.checkMessage(msg, service_secretKey)) {
            return "CHECK ERROR";
        }
        boolean isOk = consumer.handler(msg);
        return isOk ? "OK" : "ERROR";
    }
}

