/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.Date;
import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.water.dso.CallSevUtil;
import org.noear.water.model.MessageM;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.IDUtils;
import org.noear.water.utils.TextUtils;

public class MessageApi {
    public ONode subscribeTopic(String subscriber_key, String receiver_url, String access_key, String alarm_mobile, int receive_way, boolean is_unstable, String ... topics) throws Exception {
        return this.subscribeTopic(subscriber_key, "", receiver_url, access_key, alarm_mobile, receive_way, is_unstable, topics);
    }

    public ONode subscribeTopic(String subscriber_key, String subscriber_note, String receiver_url, String access_key, String alarm_mobile, int receive_way, boolean is_unstable, String ... topics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("note", subscriber_note);
        params.put("topic", String.join((CharSequence)",", topics));
        params.put("receiver_url", receiver_url);
        params.put("access_key", access_key);
        params.put("alarm_mobile", alarm_mobile);
        params.put("receive_way", receive_way + "");
        params.put("is_unstable", is_unstable ? "1" : "0");
        String txt = CallSevUtil.post("/msg/subscribe/", params);
        System.out.println("MessageApi::/msg/subscribe/:" + txt);
        return ONode.loadStr((String)txt);
    }

    public ONode unSubscribeTopic(String subscriber_key, String ... topics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("topic", String.join((CharSequence)",", topics));
        String txt = CallSevUtil.post("/msg/unsubscribe/", params);
        System.out.println("MessageApi::/msg/unsubscribe/:" + txt);
        return ONode.loadStr((String)txt);
    }

    public ONode sendMessage(String topic, String message) throws Exception {
        return this.sendMessage(null, topic, message, null);
    }

    public ONode sendMessage(String msg_key, String topic, String message) throws Exception {
        return this.sendMessage(msg_key, topic, message, null);
    }

    public ONode sendMessage(String msg_key, String topic, String message, Date planTime) throws Exception {
        return this.sendMessageAndTags(msg_key, topic, message, planTime, null);
    }

    public ONode sendMessageAndTags(String topic, String message, String tags) throws Exception {
        return this.sendMessageAndTags(null, topic, message, tags);
    }

    public ONode sendMessageAndTags(String msg_key, String topic, String message, String tags) throws Exception {
        return this.sendMessageAndTags(msg_key, topic, message, null, tags);
    }

    public ONode sendMessageAndTags(String msg_key, String topic, String message, Date planTime, String tags) throws Exception {
        if (TextUtils.isEmpty((CharSequence)msg_key)) {
            msg_key = IDUtils.guid();
        }
        if (tags == null) {
            tags = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        params.put("tags", tags);
        params.put("topic", topic);
        params.put("message", message);
        if (planTime != null) {
            String planTime2 = new Datetime(planTime).toString("yyyy-MM-dd HH:mm:ss");
            params.put("plan_time", planTime2);
        }
        String txt = CallSevUtil.post("/msg/send/", params);
        System.out.println("MessageApi::/msg/send/:" + txt);
        ONode data = ONode.loadStr((String)txt);
        if (data.get("code").getInt() == 1) {
            return data;
        }
        throw new Exception("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public ONode sendMessageCallback(String message, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageCallback(null, message, null, receiver_url, receiver_cehck);
    }

    public ONode sendMessageCallback(String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageAndTagsCallback(msg_key, message, planTime, receiver_url, receiver_cehck, null);
    }

    public ONode sendMessageAndTagsCallback(String message, String receiver_url, String receiver_cehck, String tags) throws Exception {
        return this.sendMessageAndTagsCallback(null, message, null, receiver_url, receiver_cehck, tags);
    }

    public ONode sendMessageAndTagsCallback(String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck, String tags) throws Exception {
        if (TextUtils.isEmpty((CharSequence)msg_key)) {
            msg_key = IDUtils.guid();
        }
        if (tags == null) {
            tags = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        params.put("tags", tags);
        params.put("message", message);
        params.put("receiver_url", receiver_url);
        params.put("receiver_cehck", receiver_cehck);
        if (planTime != null) {
            String planTime2 = new Datetime(planTime).toString("yyyy-MM-dd HH:mm:ss");
            params.put("plan_time", planTime2);
        }
        String txt = CallSevUtil.post("/msg/send/", params);
        System.out.println("MessageApi::/msg/send/:" + txt);
        ONode data = ONode.loadStr((String)txt);
        if (data.get("code").getInt() == 1) {
            return data;
        }
        throw new Exception("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public ONode cancelMessage(String msg_key) throws Exception {
        return this.cancelMessage(msg_key, null);
    }

    public ONode cancelMessage(String msg_key, String subscriber_key) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        String txt = CallSevUtil.post("/msg/cancel/", params);
        System.out.println("MessageApi::/msg/cancel/:" + txt);
        return ONode.loadStr((String)txt);
    }

    public ONode succeedMessage(String msg_key) throws Exception {
        return this.succeedMessage(msg_key, null);
    }

    public ONode succeedMessage(String msg_key, String subscriber_key) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        String txt = CallSevUtil.post("/msg/succeed/", params);
        System.out.println("MessageApi::/msg/succeed/:" + txt);
        return ONode.loadStr((String)txt);
    }

    public boolean checkMessage(MessageM msg, String access_key) {
        if (msg.id < 1L) {
            return false;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append(msg.id).append("#");
        sb.append(msg.key).append("#");
        sb.append(msg.topic).append("#");
        sb.append(msg.message).append("#");
        sb.append(access_key);
        String sgin_slf = EncryptUtils.md5((String)sb.toString());
        return sgin_slf.equals(msg.sgin);
    }
}

