/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.noear.water.log.Level;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.Slf4jWaterLoggerFactory;

public class Slf4jWaterLogger
implements Logger {
    private String name;

    public Slf4jWaterLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return Slf4jWaterLoggerFactory.INSTANCE.getLevel().code <= Level.TRACE.code;
    }

    public void trace(String s) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, s);
        }
    }

    public void trace(String s, Object o) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, s, o);
        }
    }

    public void trace(String s, Object o, Object o1) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, s, o, o1);
        }
    }

    public void trace(String s, Object ... objects) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, s, objects);
        }
    }

    public void trace(String s, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, s, throwable);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String s) {
        this.trace(s);
    }

    public void trace(Marker marker, String s, Object o) {
        this.trace(s, o);
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.trace(s, o, o1);
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.trace(s, objects);
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.trace(s, throwable);
    }

    public boolean isDebugEnabled() {
        return Slf4jWaterLoggerFactory.INSTANCE.getLevel().code <= Level.DEBUG.code;
    }

    public void debug(String s) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, s);
        }
    }

    public void debug(String s, Object o) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, s, o);
        }
    }

    public void debug(String s, Object o, Object o1) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, s, o, o1);
        }
    }

    public void debug(String s, Object ... objects) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, s, objects);
        }
    }

    public void debug(String s, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, s, throwable);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String s) {
        this.debug(s, (Object)s);
    }

    public void debug(Marker marker, String s, Object o) {
        this.debug(s, o);
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.debug(s, o, o1);
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.debug(s, objects);
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.debug(s, throwable);
    }

    public boolean isInfoEnabled() {
        return Slf4jWaterLoggerFactory.INSTANCE.getLevel().code <= Level.INFO.code;
    }

    public void info(String s) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, s);
        }
    }

    public void info(String s, Object o) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, s, o);
        }
    }

    public void info(String s, Object o, Object o1) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, s, o, o1);
        }
    }

    public void info(String s, Object ... objects) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, s, objects);
        }
    }

    public void info(String s, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, s, throwable);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String s) {
        this.info(s);
    }

    public void info(Marker marker, String s, Object o) {
        this.info(s, o);
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        this.info(s, o, o1);
    }

    public void info(Marker marker, String s, Object ... objects) {
        this.info(s, objects);
    }

    public void info(Marker marker, String s, Throwable throwable) {
        this.info(s, throwable);
    }

    public boolean isWarnEnabled() {
        return Slf4jWaterLoggerFactory.INSTANCE.getLevel().code <= Level.WARN.code;
    }

    public void warn(String s) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, s);
        }
    }

    public void warn(String s, Object o) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, s, o);
        }
    }

    public void warn(String s, Object ... objects) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, s, objects);
        }
    }

    public void warn(String s, Object o, Object o1) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, s, o, o1);
        }
    }

    public void warn(String s, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, s, throwable);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String s) {
        this.warn(s);
    }

    public void warn(Marker marker, String s, Object o) {
        this.warn(s, o);
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        this.warn(s, o, o1);
    }

    public void warn(Marker marker, String s, Object ... objects) {
        this.warn(s, objects);
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        this.warn(s, throwable);
    }

    public boolean isErrorEnabled() {
        return Slf4jWaterLoggerFactory.INSTANCE.getLevel().code <= Level.ERROR.code;
    }

    public void error(String s) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, s);
        }
    }

    public void error(String s, Object o) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, s, o);
        }
    }

    public void error(String s, Object o, Object o1) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, s, o, o1);
        }
    }

    public void error(String s, Object ... objects) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, s, objects);
        }
    }

    public void error(String s, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, s, throwable);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String s) {
        this.error(s);
    }

    public void error(Marker marker, String s, Object o) {
        this.error(s, o);
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        this.error(s, o, o1);
    }

    public void error(Marker marker, String s, Object ... objects) {
        this.error(s, objects);
    }

    public void error(Marker marker, String s, Throwable throwable) {
        this.error(s, throwable);
    }

    private void asyncLog(Level level, String format, Object arg) {
        FormattingTuple formatter = MessageFormatter.format((String)format, (Object)arg);
        this.asyncLog(level, formatter.getMessage(), formatter.getThrowable());
    }

    private void asyncLog(Level level, String format, Object arg1, Object arg2) {
        FormattingTuple formatter = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.asyncLog(level, formatter.getMessage(), formatter.getThrowable());
    }

    private void asyncLog(Level level, String format, Object[] args) {
        FormattingTuple formatter = MessageFormatter.arrayFormat((String)format, (Object[])args);
        this.asyncLog(level, formatter.getMessage(), formatter.getThrowable());
    }

    private void asyncLog(Level level, String msg, Throwable err) {
        if (msg == null && err == null) {
            throw new IllegalArgumentException("both message and error are null");
        }
        StringBuilder msgBuilder = new StringBuilder();
        if (msg != null) {
            msgBuilder.append(msg).append("\n");
        }
        if (err != null) {
            msgBuilder.append(err.toString());
            for (StackTraceElement stackTrace : err.getStackTrace()) {
                msgBuilder.append(stackTrace).append("\n");
            }
        }
        msgBuilder.setLength(msgBuilder.length() - 1);
        this.asyncLog(level, msgBuilder.toString());
    }

    private void asyncLog(Level level, String content) {
        Slf4jWaterLoggerFactory.INSTANCE.write(this.name, level, content);
    }
}

